/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remote.ruby;

import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslProxy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@Service
public final class RubyWslSocketProxyManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RubyWslSocketProxyManager.class);
    private final Map<Integer, WslProxy> myProxyCache = new ConcurrentHashMap<Integer, WslProxy>();

    @NotNull
    static RubyWslSocketProxyManager getInstance() {
        RubyWslSocketProxyManager rubyWslSocketProxyManager = (RubyWslSocketProxyManager)ApplicationManager.getApplication().getService(RubyWslSocketProxyManager.class);
        if (rubyWslSocketProxyManager == null) {
            RubyWslSocketProxyManager.$$$reportNull$$$0(0);
        }
        return rubyWslSocketProxyManager;
    }

    @NotNull
    WslProxy getProxy(@NotNull WSLDistribution distribution, int localPort) {
        if (distribution == null) {
            RubyWslSocketProxyManager.$$$reportNull$$$0(1);
        }
        WslProxy wslProxy = this.myProxyCache.computeIfAbsent(localPort, port -> {
            WslProxy proxy = new WslProxy((AbstractWslDistribution)distribution, port.intValue());
            Disposer.register((Disposable)this, (Disposable)proxy);
            LOG.debug("Created socket proxy for ", new Object[]{distribution, "; local port: ", port});
            return proxy;
        });
        if (wslProxy == null) {
            RubyWslSocketProxyManager.$$$reportNull$$$0(2);
        }
        return wslProxy;
    }

    void killProxy(int localPort) {
        WslProxy proxy = this.myProxyCache.remove(localPort);
        if (proxy != null) {
            LOG.debug("Killing socket proxy ", new Object[]{proxy, " for local port ", localPort});
            Disposer.dispose((Disposable)proxy);
        }
    }

    public void dispose() {
        this.myProxyCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remote/ruby/RubyWslSocketProxyManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remote/ruby/RubyWslSocketProxyManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProxy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

