/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remote.ruby;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.sync.WslHashFilters;
import com.intellij.execution.wsl.sync.WslHashMatcher;
import com.intellij.execution.wsl.sync.WslSync;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.wsl.remote.ruby.RubyWslBundle;
import com.intellij.wsl.remote.ruby.RubyWslUtil;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteSdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

final class RubyWSLRemoteTransfer
implements RubySdkTransfer {
    private static final Logger LOG = Logger.getInstance(RubyWSLRemoteTransfer.class);
    private static final String PRINT_DIRS_SH = "rb/wsl/print_dirs.sh";
    private static final int PRINT_DIRS_TIMEOUT_MS = 10000;
    private static final String SYNC_FILE_SH = "rb/wsl/sync_file.sh";
    private static final int SYNC_FILE_TIMEOUT_MS = 300000;
    private static final String RSYNC = "rsync";
    private static final WslHashFilters WSL_HASH_FILTERS = new WslHashFilters.WslHashFiltersBuilder().exclude(WslHashMatcher.Factory.fullnames(SYNC_EXCLUDE_FILENAMES)).exclude(WslHashMatcher.Factory.extensions(SYNC_EXCLUDE_EXTENSIONS)).build();
    @NotNull
    private final WSLDistribution myDistribution;
    private final RubySdkSystemAccessor myAccessor;

    RubyWSLRemoteTransfer(@NotNull RubyRemoteSdkAdditionalData data) throws ConfigurationException {
        if (data == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(0);
        }
        WSLCredentialsHolder credentialsHolder = WSLCredentialsHolder.get((RemoteSdkAdditionalData)data);
        this.myDistribution = credentialsHolder.getDistribution();
        this.myAccessor = RubySdkSystemAccessor.from((RubySdkAdditionalData)data);
    }

    public void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) throws RemoteSdkException {
        WSLDistribution wslDistribution;
        if (sdk == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(1);
        }
        if (pathMappings == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(3);
        }
        String distributionRoot = (wslDistribution = WSLCredentialsHolder.getDistribution((SdkAdditionalData)RubySdkAdditionalData.from((Sdk)sdk))) == null ? "/mnt/" : wslDistribution.getMntRoot();
        HashMap<String, String> rootsMap = new HashMap<String, String>();
        boolean[] needCleanUp = new boolean[]{false};
        Pattern pathPattern = Pattern.compile("^" + Pattern.quote(distributionRoot) + "[A-Za-z]/.+(?<!" + Pattern.quote(".lock") + ")$");
        pathMappings.forEach(pathMapping -> {
            String remoteRoot = pathMapping.getRemoteRoot();
            if (StringUtil.isEmpty((String)remoteRoot)) {
                return;
            }
            if (pathPattern.matcher(remoteRoot).matches()) {
                LOG.warn("Need cleanup because " + remoteRoot + " matches " + String.valueOf(pathPattern));
                needCleanUp[0] = true;
            } else {
                rootsMap.put(remoteRoot, pathMapping.getLocalRoot());
            }
        });
        if (needCleanUp[0]) {
            LOG.warn("Re-initializing path mappings");
            LOG.warn("CLEAN UP WSL LOCAL CACHE MANUALLY: " + RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk));
            RubyRemoteSdkConfigurator.initPathMappings((Sdk)sdk);
        }
        if (rootsMap.isEmpty()) {
            LOG.debug("No suitable path mappings to copy from WSL; sdk=", new Object[]{sdk, "; pathMappings=", pathMappings});
            return;
        }
        if (Registry.is((String)"ruby.wsl.copy.gems.using.rsync")) {
            RubyWSLRemoteTransfer.rsyncGems(sdk, indicator, rootsMap, this.myDistribution);
        } else {
            RubyWSLRemoteTransfer.syncGems(sdk, indicator, rootsMap, this.myDistribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncGems(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator, @NotNull Map<String, String> rootsMap, @NotNull WSLDistribution distro) throws RemoteSdkException {
        Set<String> remoteRootDirs;
        if (sdk == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(5);
        }
        if (rootsMap == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(6);
        }
        if (distro == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(7);
        }
        final Ref processHandlerRef = Ref.create();
        if (indicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx piex = (ProgressIndicatorEx)indicator;
            piex.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    ProcessHandler currentHandler = (ProcessHandler)processHandlerRef.get();
                    if (currentHandler != null) {
                        currentHandler.destroyProcess();
                    }
                    super.cancel();
                }
            });
        }
        try {
            remoteRootDirs = RubyWSLRemoteTransfer.extractRemoteRootDirs(rootsMap.keySet(), distro, (Consumer<? super ProcessHandler>)((Consumer)arg_0 -> ((Ref)processHandlerRef).set(arg_0)));
        }
        catch (ExecutionException | IOException e) {
            throw new RemoteSdkException(RubyWslBundle.message("error.fail.extract.remote.root.dirs", new Object[0]), e);
        }
        indicator.setIndeterminate(false);
        int total = rootsMap.size();
        double done = 0.0;
        for (Map.Entry<String, String> entry : rootsMap.entrySet()) {
            RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
            if (indicator.isCanceled()) {
                LOG.debug("Sync canceled");
                break;
            }
            String remotePath = entry.getKey();
            String localPath = entry.getValue();
            if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)localPath, (boolean)true)) {
                LOG.warn("Path '%s' is outside of the system path '%s'".formatted(localPath, PathManager.getSystemPath()));
            }
            try {
                indicator.setText2(remotePath);
                LOG.debug("Sync started: '", new Object[]{remotePath, "' => '", localPath, "'"});
                if (remoteRootDirs.contains(remotePath)) {
                    WslSync.Companion.syncWslFolders(remotePath, Path.of(localPath, new String[0]), (AbstractWslDistribution)distro, true, WSL_HASH_FILTERS, true);
                } else if (WSL_HASH_FILTERS.isFileNameOk(PathUtil.getFileName((String)remotePath))) {
                    RubyWSLRemoteTransfer.syncWslFile(remotePath, PathUtil.getParentPath((String)localPath), distro, (Consumer<? super ProcessHandler>)((Consumer)arg_0 -> ((Ref)processHandlerRef).set(arg_0)));
                }
                LOG.debug("Sync finished: '", new Object[]{remotePath, "' => '", localPath, "'"});
            }
            catch (ExecutionException e) {
                LOG.warn("Sync failed '%s' => '%s': %s".formatted(remotePath, localPath, e.getMessage()));
            }
            finally {
                double d = done;
                done = d + 1.0;
                indicator.setFraction(d / (double)total);
                processHandlerRef.set(null);
            }
        }
    }

    @NotNull
    private static Set<String> extractRemoteRootDirs(@NotNull Set<String> remoteRoots, @NotNull WSLDistribution distro, @Nullable Consumer<? super ProcessHandler> processConsumer) throws IOException, ExecutionException {
        if (remoteRoots == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(8);
        }
        if (distro == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(9);
        }
        String tmpFileWslPath = RubyWslUtil.createTempFile(distro, Strings.join(remoteRoots, (String)"\n"), "rubymine_wsl_roots", ".in");
        ProcessOutput output = RubyWslUtil.executeHelperScript(distro, processConsumer, 10000, PRINT_DIRS_SH, tmpFileWslPath);
        Set<String> set = Set.copyOf(output.getStdoutLines(true));
        if (set == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static void syncWslFile(@NotNull String remoteFilePath, @NotNull String localDirPath, @NotNull WSLDistribution distro, @Nullable Consumer<? super ProcessHandler> processConsumer) throws ExecutionException {
        if (remoteFilePath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(11);
        }
        if (localDirPath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(12);
        }
        if (distro == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(13);
        }
        String sourcePath = RubyWSLRemoteTransfer.getSourceWslPath(remoteFilePath);
        String targetPath = RubyWSLRemoteTransfer.getTargetWslPath(distro, localDirPath);
        RubyWslUtil.executeHelperScript(distro, processConsumer, 300000, SYNC_FILE_SH, sourcePath, targetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rsyncGems(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator, @NotNull Map<String, String> rootsMap, @NotNull WSLDistribution distro) {
        if (sdk == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(15);
        }
        if (rootsMap == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(16);
        }
        if (distro == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(17);
        }
        int total = rootsMap.size();
        final Ref processHandlerRef = Ref.create();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    ProcessHandler currentHandler = (ProcessHandler)processHandlerRef.get();
                    if (currentHandler != null) {
                        currentHandler.destroyProcess();
                    }
                    super.cancel();
                }
            });
        }
        indicator.setIndeterminate(false);
        double done = 0.0;
        for (Map.Entry<String, String> entry : rootsMap.entrySet()) {
            RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
            @NlsSafe String remotePath = entry.getKey();
            String localPath = entry.getValue();
            SmartList additionalArguments = new SmartList((Object)"--copy-links");
            if (FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)localPath, (boolean)true)) {
                additionalArguments.add("--delete");
            } else {
                LOG.warn(localPath + " is outside of the system path " + PathManager.getSystemPath());
            }
            for (String element : RubySdkTransfer.getSyncExcludeGlobs()) {
                additionalArguments.add("--exclude=" + element);
            }
            indicator.setText2(remotePath);
            try {
                RubyWSLRemoteTransfer.copyFromWslToWinDir(distro, remotePath, new File(localPath).getParent(), (List<String>)additionalArguments, (Consumer<? super ProcessHandler>)((Consumer)arg_0 -> ((Ref)processHandlerRef).set(arg_0)));
            }
            catch (ExecutionException e) {
                String errorMessage = "Error copying " + remotePath + " => " + localPath + ": " + e.getMessage();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(errorMessage, (Throwable)e);
                } else {
                    LOG.warn(errorMessage);
                }
            }
            finally {
                processHandlerRef.set(null);
            }
            double d = done;
            done = d + 1.0;
            indicator.setFraction(d / (double)total);
            if (!indicator.isCanceled()) continue;
            break;
        }
    }

    @NotNull
    public RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.myAccessor;
        if (rubySdkSystemAccessor == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(18);
        }
        return rubySdkSystemAccessor;
    }

    public void moveFileToLocalPath(@NotNull String sourcePath, String newParentDir, boolean replaceExisting, @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (sourcePath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(19);
        }
        if (progressIndicator == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(20);
        }
        throw new IOException("Not implemented");
    }

    @Deprecated
    private static void copyFromWslToWinDir(@NotNull WSLDistribution distribution, @NotNull String sourceWslPath, @NotNull String targetWinDirPath, @Nullable List<String> additionalOptions, @Nullable Consumer<? super ProcessHandler> handlerConsumer) throws ExecutionException {
        if (distribution == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(21);
        }
        if (sourceWslPath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(22);
        }
        if (targetWinDirPath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(23);
        }
        List command = List.of(RSYNC, "--checksum", "--recursive");
        command = ContainerUtil.concat(command, additionalOptions == null ? List.of() : additionalOptions);
        ProcessOutput process = distribution.executeOnWsl(command = ContainerUtil.append((List)command, (Object[])new String[]{RubyWSLRemoteTransfer.getSourceWslPath(sourceWslPath), RubyWSLRemoteTransfer.getTargetWslPath(distribution, targetWinDirPath)}), new WSLCommandLineOptions(), -1, handlerConsumer);
        if (process.getExitCode() != 0) {
            if (distribution.executeOnWsl(10000, new String[]{"type", RSYNC}).getExitCode() != 0) {
                throw new ExecutionException(IdeBundle.message((String)"wsl.no.rsync", (Object[])new Object[]{distribution.getMsId()}));
            }
            throw new ExecutionException(process.getStderr());
        }
    }

    @NotNull
    private static String getSourceWslPath(@NotNull String wslPath) {
        if (wslPath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(24);
        }
        String string = UriUtil.trimTrailingSlashes((String)wslPath);
        if (string == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String getTargetWslPath(@NotNull WSLDistribution distribution, @NotNull String windowsDirPath) throws ExecutionException {
        Path winDir;
        if (distribution == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(26);
        }
        if (windowsDirPath == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(27);
        }
        if (!FileUtil.createDirectory((File)(winDir = Path.of(windowsDirPath, new String[0])).toFile())) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.rsync.unable.to.create.target.dir.message", (Object[])new Object[]{winDir}));
        }
        String targetWslPath = distribution.getWslPath(winDir);
        if (targetWslPath == null) {
            throw new ExecutionException(IdeBundle.message((String)"wsl.rsync.unable.to.copy.files.dialog.message", (Object[])new Object[]{winDir}));
        }
        Object object = targetWslPath.endsWith("/") ? targetWslPath : targetWslPath + "/";
        if (object == null) {
            RubyWSLRemoteTransfer.$$$reportNull$$$0(28);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 18, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsMap";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distro";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRoots";
                break;
            }
            case 10: 
            case 18: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remote/ruby/RubyWSLRemoteTransfer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDirPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceWslPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetWinDirPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remote/ruby/RubyWSLRemoteTransfer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRemoteRootDirs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceWslPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetWslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "syncGems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractRemoteRootDirs";
                break;
            }
            case 10: 
            case 18: 
            case 25: 
            case 28: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "syncWslFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "rsyncGems";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveFileToLocalPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyFromWslToWinDir";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSourceWslPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetWslPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 18, 25, 28 -> new IllegalStateException(string);
        };
    }
}

