/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.module;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.CreateModuleKt;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtilBase;
import org.jetbrains.plugins.ruby.wizard.RubyFrameworkProjectGenerator;

final class RubyProjectPluginConfigurator
implements DirectoryProjectConfigurator {
    RubyProjectPluginConfigurator() {
    }

    public boolean isEdtRequired() {
        return false;
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        if (project == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(2);
        }
        if (isProjectCreatedWithWizard) {
            return;
        }
        Module module = CreateModuleKt.getOrInitializeModule(moduleRef, (Project)project, (VirtualFile)baseDir);
        ReadAction.nonBlocking(() -> {
            boolean isRailsProject = RailsUtil.containsRailsApp((String)baseDir.getPath());
            boolean hasGemfile = BundlerUtil.getGemfile((Module)module) != null;
            boolean hasRakeFile = RakeUtilBase.hasRakeFile((Module)module);
            boolean isGemModule = GemUtil.isGemModule((Module)module);
            boolean projectHasRubySpecificFiles = hasGemfile || hasRakeFile || isGemModule;
            return Pair.pair((Object)isRailsProject, (Object)projectHasRubySpecificFiles);
        }).expireWhen(() -> module.isDisposed()).finishOnUiThread(ModalityState.nonModal(), isRubyProjectPair -> {
            if (!((Boolean)isRubyProjectPair.first).booleanValue() && !((Boolean)isRubyProjectPair.second).booleanValue()) {
                return;
            }
            RubyProjectPluginConfigurator.configureRubyProject(project, module, baseDir, (Boolean)isRubyProjectPair.first);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void configureRubyProject(@NotNull Project project, @NotNull Module module, @NotNull VirtualFile baseDir, boolean isRailsProject) {
        if (project == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            RubyProjectPluginConfigurator.$$$reportNull$$$0(5);
        }
        module.setModuleType("RUBY_MODULE");
        SdkConfigurationUtil.configureDirectoryProjectSdk((Project)project, null, (SdkType[])RubySdkGemsConfigurableBase.getAllRubySdkTypes());
        StartupManager.getInstance((Project)project).runAfterOpened(() -> ModuleRootModificationUtil.updateModel((Module)module, model -> RubyFrameworkProjectGenerator.setupStandardTestSourceRoots((VirtualFile)baseDir, (ModifiableRootModel)model)));
        if (isRailsProject) {
            RailsFacetUtil.configureRailsFacet((VirtualFile)baseDir, (Module)module);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/module/RubyProjectPluginConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configureRubyProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

