/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.module.ui.loadPath.RLoadPathChooserPanel;

public class RLoadPathChooser
extends ModuleElementsEditor {
    private RLoadPathChooserPanel myRLoadPathChooserPanel;
    private List<String> myLoadPaths;

    protected RLoadPathChooser(ModuleConfigurationState state) {
        super(state);
    }

    protected JComponent createComponentImpl() {
        this.myLoadPaths = new ArrayList<String>(RubyModuleSettings.getInstance((Module)this.getModel().getModule()).getLoadPaths());
        this.myRLoadPathChooserPanel = new RLoadPathChooserPanel(this.myLoadPaths, this.getState().getProject());
        return this.myRLoadPathChooserPanel.getContentPane();
    }

    public boolean isModified() {
        return this.myRLoadPathChooserPanel.isModified();
    }

    public void saveData() {
        if (this.isModified() && this.myRLoadPathChooserPanel != null) {
            this.myRLoadPathChooserPanel.apply();
            RubyModuleSettings.getInstance((Module)this.getModel().getModule()).setLoadPathDirs(this.myLoadPaths);
        }
    }

    public String getDisplayName() {
        return RLoadPathChooser.getName();
    }

    @NonNls
    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public static ModuleConfigurationEditor createModuleConfigurationEditor(ModuleConfigurationState state) {
        return new RLoadPathChooser(state);
    }

    @NlsContexts.ConfigurableName
    public static String getName() {
        return RBundle.message((String)"module.settings.dialog.load.path.tab.title");
    }
}

