/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.JRubyTypeConventions;
import org.jetbrains.plugins.ruby.java.jruby.types.RJavaClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;

public final class RJavaTypeFactory {
    private RJavaTypeFactory() {
    }

    @NotNull
    public static RType createType(Project project, PsiType type, Context context) {
        String name;
        String rubyCoreType;
        PsiClass psiClass;
        if (type instanceof PsiClassType && type.isValid() && (psiClass = ((PsiClassType)type).resolve()) != null) {
            String rubyCoreType2 = JRubyTypeConventions.getRubyType(type.getCanonicalText());
            if (rubyCoreType2 != null) {
                Symbol symbol = SymbolUtil.findConstantByFQN((Project)project, (Type)Type.CLASS, (String)rubyCoreType2, null);
                RType rType = RTypeFactory.createTypeBySymbol((Symbol)symbol);
                if (rType == null) {
                    RJavaTypeFactory.$$$reportNull$$$0(0);
                }
                return rType;
            }
            RType rType = RJavaClassType.createClassOrInstanceTypeDependingOnContext(new RJavaClassSymbol(psiClass), psiClass, context);
            if (rType == null) {
                RJavaTypeFactory.$$$reportNull$$$0(1);
            }
            return rType;
        }
        if (type instanceof PsiArrayType) {
            Symbol symbol = SymbolUtil.findConstantByFQN((Project)project, (Type)Type.CLASS, (String)"Array", null);
            RType rType = RTypeFactory.createTypeBySymbol((Symbol)symbol);
            if (rType == null) {
                RJavaTypeFactory.$$$reportNull$$$0(2);
            }
            return rType;
        }
        if (type instanceof PsiPrimitiveType && (rubyCoreType = JRubyTypeConventions.getRubyType(name = type.getCanonicalText())) != null) {
            Symbol symbol = SymbolUtil.findConstantByFQN((Project)project, (Type)Type.CLASS, (String)rubyCoreType, null);
            RType rType = RTypeFactory.createTypeBySymbol((Symbol)symbol);
            if (rType == null) {
                RJavaTypeFactory.$$$reportNull$$$0(3);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RJavaTypeFactory.$$$reportNull$$$0(4);
        }
        return rEmptyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/java/jruby/types/RJavaTypeFactory", "createType"));
    }
}

