/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaPackageSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.RAbstractJavaType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;

public class RJavaPackageType
extends RAbstractJavaType {
    private final PsiPackage myPackage;

    @Override
    protected Project getProject() {
        return this.myPackage.getProject();
    }

    public RJavaPackageType(PsiPackage aPackage) {
        super((Context)ContextImpl.CLASS);
        this.myPackage = aPackage;
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            RJavaPackageType.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            RJavaPackageType.$$$reportNull$$$0(1);
        }
        Processor processor = SymbolUtil.createSymbolProcessor(filter, consumer);
        this.processAllPackages((Processor<? super Symbol>)processor);
        this.processClassesMessages((Processor<? super Symbol>)processor);
        this.processProxyMethods((Processor<? super Symbol>)processor, null, invocationPoint);
    }

    private boolean processClassesMessages(Processor<? super Symbol> processor) {
        PsiClass[] classes;
        for (PsiClass psiClass : classes = this.myPackage.getClasses()) {
            String name = psiClass.getName();
            if (name == null || processor.process((Object)new RJavaClassSymbol(psiClass, name))) continue;
            return false;
        }
        return true;
    }

    private boolean processAllPackages(Processor<? super Symbol> processor) {
        PsiPackage[] psiPackages;
        for (PsiPackage psiPackage : psiPackages = this.myPackage.getSubPackages()) {
            String name = psiPackage.getName();
            if (name == null || processor.process((Object)new RJavaPackageSymbol(psiPackage, name))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, PsiElement invocationPoint) {
        if (name == null) {
            RJavaPackageType.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            RJavaPackageType.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        Symbol symbol = this.findMemberSymbol(name);
        if (symbol == null) {
            symbol = this.findProxyMethod(name, invocationPoint);
        }
        return symbol != null && filter.test((Symbol)symbol) ? symbol : null;
    }

    @Nullable
    protected Symbol findMemberSymbol(String name) {
        String childName;
        Project project = this.myPackage.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass childClass = facade.findClass(childName = this.myPackage.getQualifiedName() + "." + name, GlobalSearchScope.allScope((Project)project));
        if (childClass != null) {
            return new RJavaClassSymbol(childClass, name);
        }
        PsiPackage childPackage = facade.findPackage(childName);
        if (childPackage != null) {
            return new RJavaPackageSymbol(childPackage, name);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RJavaPackageType type = (RJavaPackageType)((Object)o);
        return Objects.equals(this.myPackage, type.myPackage);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.myPackage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/types/RJavaPackageType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processMembers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMemberForName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

