/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.symbols;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyImportIndex;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FileRequireCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.RubyProcessedFilesMap;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class JavaResolveUtil {
    @NonNls
    public static final String[] TOP_LEVEL_JAVA_ALLOWED = new String[]{"java", "javax", "org", "com"};

    private JavaResolveUtil() {
    }

    public static boolean isTopLevelPackageOk(@NotNull PsiPackage packaggge) {
        if (packaggge == null) {
            JavaResolveUtil.$$$reportNull$$$0(0);
        }
        String name = packaggge.getQualifiedName();
        for (String s : TOP_LEVEL_JAVA_ALLOWED) {
            if (!name.startsWith(s) || name.length() != s.length() && name.charAt(s.length()) != '.') continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiPackage getPsiPackage(@NotNull PsiClass psiClass) {
        int i;
        if (psiClass == null) {
            JavaResolveUtil.$$$reportNull$$$0(1);
        }
        PsiPackage result = null;
        String fqn = psiClass.getQualifiedName();
        if (fqn != null && (i = fqn.lastIndexOf(46)) >= 0) {
            String packageName = fqn.substring(0, i);
            result = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findPackage(packageName);
        }
        return result;
    }

    public static boolean isClassInsideTopLevelPackage(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaResolveUtil.$$$reportNull$$$0(2);
        }
        boolean result = false;
        PsiPackage psiPackage = JavaResolveUtil.getPsiPackage(psiClass);
        if (psiPackage != null) {
            result = JavaResolveUtil.isTopLevelPackageOk(psiPackage);
        }
        return result;
    }

    @Nullable
    public static PsiElement getPsiElement(@NotNull Project project, @NotNull String fullName) {
        String processedName;
        JavaPsiFacade javaPsiFacade;
        PsiPackage psiPackage;
        if (project == null) {
            JavaResolveUtil.$$$reportNull$$$0(3);
        }
        if (fullName == null) {
            JavaResolveUtil.$$$reportNull$$$0(4);
        }
        if ((psiPackage = (javaPsiFacade = JavaPsiFacade.getInstance((Project)project)).findPackage(processedName = JavaResolveUtil.processName(fullName))) != null) {
            return psiPackage;
        }
        return javaPsiFacade.findClass(processedName, GlobalSearchScope.allScope((Project)project));
    }

    private static String processName(String name) {
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)"Java.")) {
            return name.substring("Java".length() + 1);
        }
        return name;
    }

    @Nullable
    public static PsiElement getPsiElement(@NotNull Project project, @NotNull List<String> path, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            JavaResolveUtil.$$$reportNull$$$0(5);
        }
        if (path == null) {
            JavaResolveUtil.$$$reportNull$$$0(6);
        }
        if (path.size() == 1) {
            Collection calls = (Collection)ReadAction.compute(() -> JRubyImportIndex.getInstance().getElements(project, (SearchScope)GlobalSearchScope.allScope((Project)project), (String)path.get(0)));
            if (Registry.is((String)"ruby.disable.require.processing", (boolean)true)) {
                Optional<RPossibleCall> result = calls.stream().filter(call -> {
                    List args = (List)call.getData(new RubyCallType[0]);
                    PsiElement element = JavaResolveUtil.getPsiElement(project, StringUtil.join((Collection)((FQN)args.get(0)).asList(), (String)"."));
                    return Optional.ofNullable(element).filter(it -> it.isValid()).map(PsiElement::getContainingFile).map(PsiFile::getVirtualFile).map(it -> GlobalSearchScope.allScope((Project)project).contains(it)).orElse(false);
                }).findAny();
                if (result.isPresent()) {
                    List args = (List)result.get().getData(new RubyCallType[0]);
                    return JavaResolveUtil.getPsiElement(project, StringUtil.join((Collection)((FQN)args.get(0)).asList(), (String)"."));
                }
            } else {
                Module module = invocationPoint != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)invocationPoint) : null;
                RFile invocationPointFile = invocationPoint != null ? RubyPsiUtil.getRFile((PsiElement)invocationPoint) : null;
                RubyProcessedFilesMap map = invocationPointFile != null ? FileRequireCache.getInstance((Project)project).getProcessedFilesMap((RTopLevelContainer)invocationPointFile) : null;
                for (RPossibleCall call2 : calls) {
                    List args = (List)call2.getData(new RubyCallType[0]);
                    PsiElement element = JavaResolveUtil.getPsiElement(project, StringUtil.join((Collection)((FQN)args.get(0)).asList(), (String)"."));
                    if (element == null || map != null && !RubyFQNUtil.isInProcessedFiles((Project)project, (RPsiElement)call2, (Module)module, (Collection)map.getFiles())) continue;
                    return element;
                }
            }
        }
        return JavaResolveUtil.getPsiElement(project, StringUtil.join(path, (String)"."));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packaggge";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/symbols/JavaResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopLevelPackageOk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassInsideTopLevelPackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

