/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaPrimitiveTypeSymbol;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaPackageSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public class JRubyJavaImportSymbol
extends TopLevelSymbolImpl {
    @NonNls
    public static final String TEXT = "Java";

    public JRubyJavaImportSymbol(@NotNull Project project, @Nullable RFile file) {
        if (project == null) {
            JRubyJavaImportSymbol.$$$reportNull$$$0(0);
        }
        super(project, (PsiElement)file);
    }

    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        PsiPackage[] packages;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        for (String string : JavaResolveUtil.TOP_LEVEL_JAVA_ALLOWED) {
            PsiPackage psiPackage = psiFacade.findPackage(string);
            if (psiPackage == null || processor.process((Symbol)new RJavaPackageSymbol(psiPackage, string))) continue;
            return false;
        }
        PsiPackage topPackage = psiFacade.findPackage("");
        PsiPackage[] psiPackageArray = packages = topPackage != null ? topPackage.getSubPackages() : null;
        if (topPackage == null) {
            return false;
        }
        for (PsiPackage psiPackage : packages) {
            String name = psiPackage.getName();
            if (name == null || processor.process((Symbol)new RJavaPackageSymbol(psiPackage, name))) continue;
            return false;
        }
        for (JavaPrimitiveTypeSymbol javaPrimitiveTypeSymbol : JavaPrimitiveTypeSymbol.getSymbols(this.myProject)) {
            if (processor.process((Symbol)javaPrimitiveTypeSymbol)) continue;
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/java/jruby/symbols/JRubyJavaImportSymbol", "<init>"));
    }
}

