/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.java.jruby.JRubyNameConventions;
import org.jetbrains.plugins.ruby.java.jruby.psi.RubyPsiClassWrapper;
import org.jetbrains.plugins.ruby.java.jruby.psi.RubyPsiMethodWrapper;
import org.jetbrains.plugins.ruby.java.jruby.search.JRubyClassInheritorsSearcher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;

public final class JRubyOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiMethod> consumer) {
        if (queryParameters == null) {
            JRubyOverridingMethodsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JRubyOverridingMethodsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = (PsiClass)ReadAction.compute(() -> queryParameters.getMethod().getContainingClass());
        SearchScope scope = queryParameters.getScope();
        DirectClassInheritorsSearch.SearchParameters params = new DirectClassInheritorsSearch.SearchParameters(psiClass, scope);
        return new JRubyClassInheritorsSearcher().execute(params, (Processor<? super PsiClass>)((Processor)psiClass1 -> {
            RMethodHolder rClass = (RMethodHolder)((RubyPsiClassWrapper)psiClass1).getRClass();
            List methodList = rClass.getMethods();
            for (RMethod rMethod : methodList) {
                String queryName = queryParameters.getMethod().getName();
                for (String name : JRubyNameConventions.getJavaNames(rMethod.getName())) {
                    if (name == null || !name.equals(queryName) || consumer.process((Object)new RubyPsiMethodWrapper(rMethod, (PsiClass)psiClass1))) continue;
                    return false;
                }
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/java/jruby/search/JRubyOverridingMethodsSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

