/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.java.jruby.JRubySupport;
import org.jetbrains.plugins.ruby.java.jruby.psi.RubyPsiClassWrapper;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class JRubyClassInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiClass> consumer) {
        if (queryParameters == null) {
            JRubyClassInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JRubyClassInheritorsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = queryParameters.getClassToProcess();
        String className = (String)ReadAction.compute(() -> psiClass.getName());
        Ref resultRef = new Ref((Object)Boolean.TRUE);
        if (className != null && queryParameters.getScope() instanceof GlobalSearchScope) {
            ApplicationManager.getApplication().runReadAction(() -> {
                Collection elements = RubyInheritanceIndex.getInstance().getElements(psiClass.getProject(), queryParameters.getScope(), className);
                List containers = ContainerUtil.map((Collection)elements, it -> it instanceof RCall ? SymbolUtil.getContextContainer((PsiElement)it) : (RContainer)it);
                for (RElementWithFQN elementWithFQN : containers) {
                    boolean result;
                    RContainer container;
                    if (!(elementWithFQN instanceof RContainer) || !JRubySupport.hasJRubySupport((PsiElement)(container = (RContainer)elementWithFQN)) || (result = JRubyClassInheritorsSearcher.processJavaSuperClasses((RElementWithFQN)container, (Processor<? super PsiClass>)((Processor)superClass -> !superClass.equals((Object)psiClass) || consumer.process((Object)new RubyPsiClassWrapper(container)))))) continue;
                    resultRef.set((Object)Boolean.FALSE);
                    break;
                }
            });
        }
        return (Boolean)resultRef.get();
    }

    public static boolean processJavaSuperClasses(RElementWithFQN aClass, Processor<? super PsiClass> consumer) {
        PsiClass includedClass;
        Symbol superClassSymbol;
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)aClass);
        if (!(classSymbol instanceof ClassModuleSymbol)) {
            return true;
        }
        if (classSymbol.getType() == Type.CLASS && (superClassSymbol = ((ClassModuleSymbol)classSymbol).getSuperClassSymbol(null)) instanceof RJavaClassSymbol && !consumer.process((Object)(includedClass = (PsiClass)((RJavaClassSymbol)superClassSymbol).getPsiElement()))) {
            return false;
        }
        for (Symbol includeSymbol : ((ClassModuleSymbol)classSymbol).getIncludeSymbols(null)) {
            PsiClass includedClass2;
            if (!(includeSymbol instanceof RJavaClassSymbol) || consumer.process((Object)(includedClass2 = (PsiClass)((RJavaClassSymbol)includeSymbol).getPsiElement()))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/java/jruby/search/JRubyClassInheritorsSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

