/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.codeInsight.references.StringImportReferenceUtil;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class JRubyStringImportToDotReferenceIntention
extends AbstractIntentionAction {
    private static final Set<String> TOP_PACKAGES = Set.of("com", "java", "javax", "org");

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.string.import.to.dot.reference");
        if (string == null) {
            JRubyStringImportToDotReferenceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            JRubyStringImportToDotReferenceIntention.$$$reportNull$$$0(1);
        }
        return StringImportReferenceUtil.isIntentionAvailable(editor, psiFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        RPsiElement generated;
        if (project == null) {
            JRubyStringImportToDotReferenceIntention.$$$reportNull$$$0(2);
        }
        RBaseString string = (RBaseString)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(editor.getCaretModel().getOffset()), RBaseString.class);
        assert (string != null);
        Object content = string.getContent();
        boolean topLevel = false;
        for (String str : TOP_PACKAGES) {
            if (!((String)content).startsWith(str)) continue;
            topLevel = true;
            break;
        }
        if (!topLevel) {
            content = "Java::" + (String)content;
        }
        if (!((generated = RubyElementFactoryCore.createElementFromText((PsiElement)string, (String)(JRubyCallTypeProvider.JAVA_IMPORT_CALL.getCommandName() + " " + (String)content))) instanceof RCall)) {
            return;
        }
        List arguments = ((RCall)generated).getArguments();
        if (arguments.size() != 1) {
            return;
        }
        string.replace((PsiElement)arguments.get(0));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyStringImportToDotReferenceIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyStringImportToDotReferenceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

