/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyCallTypeProvider;
import org.jetbrains.plugins.ruby.java.jruby.symbols.JavaResolveUtil;
import org.jetbrains.plugins.ruby.java.jruby.symbols.RJavaClassSymbol;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class JRubyQualifiedNameToImportIntention
extends AbstractIntentionAction {
    private static final RubyCallType<List<FQN>> IMPORT_TYPE = JRubyCallTypeProvider.JAVA_IMPORT_CALL;

    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.qualified.name.to.import");
        if (string == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        RReference reference;
        if (project == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(1);
        }
        if ((reference = JRubyQualifiedNameToImportIntention.getReference(editor, psiFile)) == null) {
            return false;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference.getReference());
        return symbol != null && symbol.getType() == JavaSymbolTypes.JAVA_CLASS;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        RPsiElement generatedName;
        RReference reference;
        if (project == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(2);
        }
        if ((reference = JRubyQualifiedNameToImportIntention.getReference(editor, psiFile)) == null) {
            return;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference.getReference());
        if (!(symbol instanceof RJavaClassSymbol)) {
            return;
        }
        String className = symbol.getName();
        RPsiElement rPsiElement = generatedName = className != null ? RubyElementFactoryCore.createElementFromText((PsiElement)reference, (String)className) : null;
        if (generatedName == null) {
            return;
        }
        RContainer container = JRubyQualifiedNameToImportIntention.getClassOrModuleOfFile((PsiElement)(reference = reference.replace((PsiElement)generatedName)));
        if (container == null) {
            return;
        }
        if (JRubyQualifiedNameToImportIntention.findImport(container, (RJavaClassSymbol)symbol)) {
            return;
        }
        PsiClass element = (PsiClass)((RJavaClassSymbol)symbol).getPsiElement();
        String fqn = element.getQualifiedName();
        if (fqn == null) {
            return;
        }
        boolean topLevelPackage = JavaResolveUtil.isClassInsideTopLevelPackage(element);
        String text = IMPORT_TYPE.getCommandName() + " " + (String)(topLevelPackage ? fqn : "'" + fqn + "'");
        RPsiElement generated = RubyElementFactoryCore.createElementFromText((PsiElement)reference, (String)text);
        List statements = container.getStatements();
        if (statements.isEmpty()) {
            RCompoundStatement statement = container.getCompoundStatement();
            statement.getParent().addBefore((PsiElement)generated, (PsiElement)statement);
        } else {
            boolean importSectionFound = false;
            RPsiElement prevStatement = null;
            for (RPsiElement statement : statements) {
                boolean isImport = JRubyQualifiedNameToImportIntention.isImportStatement(statement);
                if (importSectionFound && !isImport) {
                    prevStatement.getParent().addAfter((PsiElement)generated, (PsiElement)prevStatement);
                    break;
                }
                if (!importSectionFound) {
                    importSectionFound = isImport;
                }
                prevStatement = statement;
            }
            if (!importSectionFound) {
                RPsiElement anchorStatement = (RPsiElement)statements.get(0);
                PsiElement parent = anchorStatement.getParent();
                if (JRubyQualifiedNameToImportIntention.isIncludeJavaStatement(anchorStatement)) {
                    parent.addAfter((PsiElement)generated, (PsiElement)anchorStatement);
                } else {
                    parent.addBefore((PsiElement)generated, (PsiElement)anchorStatement);
                }
            }
        }
    }

    private static boolean findImport(@NotNull RContainer file, @NotNull RJavaClassSymbol symbol) {
        if (file == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(3);
        }
        if (symbol == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(4);
        }
        final Ref ref = new Ref((Object)false);
        final String className = ((PsiClass)symbol.getPsiElement()).getQualifiedName();
        if (className == null) {
            return false;
        }
        RubyRecursiveElementVisitor visitor = new RubyRecursiveElementVisitor(){

            public void visitRCall(@NotNull RCall rCall) {
                String str;
                if (rCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JRubyCallTypeProvider.isJrubyImportCallType(rCall.getCallType())) {
                    return;
                }
                List arguments = rCall.getArguments();
                if (arguments.size() != 1) {
                    return;
                }
                RPsiElement element = (RPsiElement)arguments.get(0);
                String string = str = element instanceof RBaseString ? ((RBaseString)element).getContent() : element.getText();
                if (className.equals(str)) {
                    ref.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCall", "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyQualifiedNameToImportIntention$1", "visitRCall"));
            }
        };
        file.accept((PsiElementVisitor)visitor);
        return (Boolean)ref.get();
    }

    @Nullable
    private static RReference getReference(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(6);
        }
        return (RReference)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), RReference.class);
    }

    private static boolean isImportStatement(@NotNull RPsiElement statement) {
        if (statement == null) {
            JRubyQualifiedNameToImportIntention.$$$reportNull$$$0(7);
        }
        if (statement instanceof RModifierStatement) {
            return JRubyQualifiedNameToImportIntention.isImportStatement(((RModifierStatement)statement).getCommand());
        }
        return statement instanceof RCall && JRubyCallTypeProvider.isJrubyImportCallType(((RCall)statement).getCallType());
    }

    private static boolean isIncludeJavaStatement(RPsiElement statement) {
        if (statement instanceof RModifierStatement) {
            return JRubyQualifiedNameToImportIntention.isIncludeJavaStatement(((RModifierStatement)statement).getCommand());
        }
        RubyCallType type = statement instanceof RCall ? ((RCall)statement).getCallType() : null;
        return statement instanceof RCall && "java".equals(StringUtil.toLowerCase((String)((RCall)statement).getCallArguments().getText())) && (type == RubyIncludeExtendCallTypes.INCLUDE_CALL || type == RubyCallTypesCore.REQUIRE_CALL);
    }

    @Nullable
    private static RContainer getClassOrModuleOfFile(PsiElement element) {
        RContainer container;
        PsiElement parent = element.getParent();
        if (parent instanceof RSuperClass) {
            element = parent.getParent().getParent();
        }
        RContainer rContainer = container = element instanceof RContainer ? (RContainer)element : (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        while (container instanceof RMethod) {
            container = container.getParentContainer();
        }
        return container;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyQualifiedNameToImportIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/intentions/JRubyQualifiedNameToImportIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findImport";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isImportStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

