/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.codeInsight.references.StringImportReferenceUtil;
import org.jetbrains.plugins.ruby.java.jruby.psi.JRubyCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyStringImportInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            JRubyStringImportInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JRubyStringImportInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        MyVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRCall(@NotNull RCall rCall) {
            Object e;
            Module module;
            if (rCall == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rCall)) == null) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            RubyCallType type = rCall.getCallType();
            if (!JRubyCallTypeProvider.isJrubyImportCallType(type) || type == JRubyCallTypeProvider.IMPORT_CALL && !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
                return;
            }
            List arguments = rCall.getArguments();
            if (arguments.isEmpty() || !((e = arguments.get(0)) instanceof RBaseString)) {
                return;
            }
            RBaseString string = (RBaseString)e;
            String content = string.getContent();
            ArrayList<RubyFix> list = new ArrayList<RubyFix>();
            if (content.contains("::")) {
                list.add(new JRubyStringImportColonFix());
            }
            if (StringUtil.startsWith((CharSequence)content, (CharSequence)"Java")) {
                list.add(new MyQuickFix());
            }
            if (!StringImportReferenceUtil.checkBaseString(string)) {
                this.registerProblem((PsiElement)string, RBundle.message((String)"inspection.jruby.string.import.message"), list.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCall", "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection$MyVisitor", "visitRCall"));
        }

        private static class JRubyStringImportColonFix
        extends RubyFix {
            private JRubyStringImportColonFix() {
            }

            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                RBaseString element;
                RPsiElement generated;
                if (project == null) {
                    JRubyStringImportColonFix.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    JRubyStringImportColonFix.$$$reportNull$$$0(1);
                }
                if ((generated = RubyElementFactoryCore.createElementFromText((PsiElement)(element = (RBaseString)descriptor.getPsiElement()), (String)("\"" + element.getContent().replace("::", ".") + "\""))) instanceof RBaseString) {
                    element.replace((PsiElement)generated);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = RBundle.message((String)"inspection.jruby.string.import.fix1");
                if (string == null) {
                    JRubyStringImportColonFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection$MyVisitor$JRubyStringImportColonFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection$MyVisitor$JRubyStringImportColonFix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private static class MyQuickFix
        extends RubyFix {
            private MyQuickFix() {
            }

            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                RPsiElement generated;
                if (project == null) {
                    MyQuickFix.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    MyQuickFix.$$$reportNull$$$0(1);
                }
                RBaseString element = (RBaseString)descriptor.getPsiElement();
                String content = element.getContent();
                int symbolLen = "Java".length();
                int index = 0;
                if (content.charAt(symbolLen) == ':' && content.charAt(symbolLen + 1) == ':') {
                    index = symbolLen + 2;
                }
                if (content.charAt(symbolLen) == '.') {
                    index = symbolLen + 1;
                }
                if ((generated = RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)("\"" + content.substring(index) + "\""))) instanceof RBaseString) {
                    element.replace((PsiElement)generated);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = RBundle.message((String)"inspection.jruby.string.import.fix2");
                if (string == null) {
                    MyQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection$MyVisitor$MyQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyStringImportInspection$MyVisitor$MyQuickFix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

