/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyJavaFieldAccessInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            JRubyJavaFieldAccessInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JRubyJavaFieldAccessInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyJavaFieldAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyJavaFieldAccessInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRColonReference(@NotNull RColonReference rColonReference) {
            if (rColonReference == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.processReference((RReference)rColonReference);
        }

        public void visitRDotReference(@NotNull RDotReference rDotReference) {
            if (rDotReference == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.processReference((RReference)rDotReference);
        }

        private void processReference(RReference reference) {
            Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference.getReference());
            if (symbol == null) {
                Optional<Symbol> receiverSymbol = Optional.ofNullable(reference.getReceiver()).map(PsiElement::getReference).map(ResolveUtil::resolveToSymbolWithCaching);
                String referenceCommand = reference.getCommand();
                if (receiverSymbol.isPresent() && StringUtil.isNotEmpty((String)referenceCommand)) {
                    symbol = SymbolUtil.lookupSymbolInHierarchy((Symbol)receiverSymbol.get(), (String)referenceCommand, (TypeSet)JavaSymbolTypes.JAVA_FIELD.asSet(), (PsiElement)reference);
                }
            }
            if (symbol == null) {
                return;
            }
            PsiElement element = symbol.getPsiElement();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field instanceof PsiEnumConstant && reference instanceof RDotReference) {
                this.registerProblem((PsiElement)reference, RBundle.message((String)"inspection.jruby.java.field.access.enum.message"), new LocalQuickFix[]{new MyQuickFix()});
            } else if (!field.hasModifierProperty("public")) {
                this.registerProblem((PsiElement)reference, RBundle.message((String)"inspection.jruby.java.field.access.message"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rColonReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rDotReference";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyJavaFieldAccessInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRColonReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDotReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyQuickFix
        extends RubyFix {
            private MyQuickFix() {
            }

            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
                if (project == null) {
                    MyQuickFix.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    MyQuickFix.$$$reportNull$$$0(1);
                }
                RDotReference reference = (RDotReference)descriptor.getPsiElement();
                String text = reference.getText();
                int index = text.lastIndexOf(46);
                RExpression generated = RubyElementFactoryCore.createExpressionFromText((PsiElement)reference, (String)(text.substring(0, index) + "::" + text.substring(index + 1)));
                reference.replace((PsiElement)generated);
            }

            @NotNull
            public String getFamilyName() {
                String string = RBundle.message((String)"inspection.jruby.java.field.access.enum.fix");
                if (string == null) {
                    MyQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyJavaFieldAccessInspection$MyVisitor$MyQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyJavaFieldAccessInspection$MyVisitor$MyQuickFix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

