/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.inspections;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.java.jruby.codeInsight.implement.JRubyImplementHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyImplementInterfaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Sdk sdk;
        if (holder == null) {
            JRubyImplementInterfaceInspection.$$$reportNull$$$0(0);
        }
        if ((sdk = RubySdkUtil.findRubySdk((PsiElement)holder.getFile())) == null || !JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JRubyImplementInterfaceInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyImplementInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyImplementInterfaceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends RubyInspectionVisitor {
        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRClass(@NotNull RClass rClass) {
            List<ClassMember> methods;
            Symbol symbol;
            if (rClass == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass)) != null && !(methods = JRubyImplementHandler.createImplementMembers(symbol)).isEmpty()) {
                String message = RBundle.message((String)"inspection.implement.interface.class.should.implement.method", (Object[])new Object[]{methods.get(0).getText()});
                ((StreamEx)((StreamEx)StreamEx.iterate((Object)rClass.getLastChild(), PsiTreeUtil::prevLeaf).takeWhile(Objects::nonNull)).filter(MyVisitor::isAllWhitespaces)).findFirst().ifPresent(it -> this.registerProblem((PsiElement)rClass.getClassName(), message, new LocalQuickFix[]{new MyQuickFix((PsiElement)it, symbol)}));
            }
        }

        private static boolean isAllWhitespaces(@NotNull PsiElement it) {
            if (it == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            return it instanceof PsiWhiteSpace || it instanceof LeafPsiElement && it.getText().chars().allMatch(Character::isWhitespace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "it";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyImplementInterfaceInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAllWhitespaces";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        protected Symbol mySymbol;
        protected SmartPsiElementPointer<PsiElement> myEndElementPointer;

        private MyQuickFix(@NotNull PsiElement endElement, @NotNull Symbol symbol) {
            if (endElement == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (symbol == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            this.myEndElementPointer = SmartPointerManager.createPointer((PsiElement)endElement);
            this.mySymbol = symbol;
        }

        @NotNull
        public String getName() {
            String string = RBundle.message((String)"inspection.implement.interface.fix");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.group.jruby.name");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if (previewDescriptor == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            return new IntentionPreviewInfo.Html(RBundle.message((String)"inspection.implement.interface.preview"));
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            Editor editor = null;
            PsiFile file = this.myEndElementPointer.getContainingFile();
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getEditors(virtualFile)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                    break;
                }
                if (editor == null) {
                    return;
                }
                JRubyImplementHandler.execute(editor, project, this.myEndElementPointer.getElement(), this.mySymbol);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyImplementInterfaceInspection$MyQuickFix";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/inspections/JRubyImplementInterfaceInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

