/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.facet;

import com.intellij.facet.FacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacet;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacetConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public final class JRubySupportProvider
implements RubySupportProvider {
    private static final Logger LOG = Logger.getInstance(JRubySupportProvider.class);

    @Nullable
    public Sdk findRubySdk(Module module) {
        for (JRubyFacet jRubyFacet : JRubySupportProvider.getJRubyFacets(module)) {
            Sdk sdk = jRubyFacet.getRubySdk();
            if (sdk == null || !(sdk.getSdkType() instanceof RubySdkType)) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public Sdk findRubySdkFromOrderEntry(OrderEntry orderEntry) {
        String name;
        if (orderEntry instanceof LibraryOrderEntry && (name = ((LibraryOrderEntry)orderEntry).getLibraryName()) != null && name.endsWith(" facet library")) {
            Sdk[] sdks;
            for (Sdk sdk : sdks = JRubySdkUtil.getValidSdks()) {
                if (sdk == null || !JRubyFacet.getFacetLibraryName(sdk.getName()).equals(name)) continue;
                return sdk;
            }
        }
        return null;
    }

    public RSupportPerModuleSettings findRubySettings(@NotNull Module module) {
        Collection<? extends JRubyFacet> jrubyFacets;
        if (module == null) {
            JRubySupportProvider.$$$reportNull$$$0(0);
        }
        if (!(jrubyFacets = JRubySupportProvider.getJRubyFacets(module)).isEmpty()) {
            JRubyFacet jRubyFacet = jrubyFacets.iterator().next();
            return (RSupportPerModuleSettings)jRubyFacet.getConfiguration();
        }
        return null;
    }

    public boolean hasRubySupport(@NotNull Module module) {
        if (module == null) {
            JRubySupportProvider.$$$reportNull$$$0(1);
        }
        return !JRubySupportProvider.getJRubyFacets(module).isEmpty();
    }

    public boolean updateFacetSdk(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            JRubySupportProvider.$$$reportNull$$$0(2);
        }
        if (!this.hasRubySupport(module)) {
            LOG.warn("Module must have ruby support here");
            return false;
        }
        for (JRubyFacet jRubyFacet : JRubySupportProvider.getJRubyFacets(module)) {
            ((JRubyFacetConfiguration)jRubyFacet.getConfiguration()).setSdk(sdk);
        }
        return true;
    }

    @NotNull
    private static Collection<? extends JRubyFacet> getJRubyFacets(@NotNull Module module) {
        if (module == null) {
            JRubySupportProvider.$$$reportNull$$$0(3);
        }
        Collection collection = FacetManager.getInstance((Module)module).getFacetsByType(JRubyFacet.ID);
        if (collection == null) {
            JRubySupportProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/facet/JRubySupportProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/facet/JRubySupportProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJRubyFacets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRubySettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasRubySupport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateFacetSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJRubyFacets";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

