/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby.debug.ui;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NonNls;

public final class JRubyNodeRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "JRubyRenderer";
    @NonNls
    private static final String JRUBY_SCOPE_PACKAGE = "org.jruby.runtime.scope";
    private final MyCachedEvaluator myChildrenNameExpression = new MyCachedEvaluator();

    public JRubyNodeRenderer() {
        super("JRuby", true);
        this.myChildrenNameExpression.setReferenceExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "locals.getStaticScope().getVariables()"));
    }

    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        String name = descriptor.getName();
        if ("locals".equals(name)) {
            return " JRuby local variables";
        }
        return NodeRendererSettings.getInstance().getToStringRenderer().calcLabel(descriptor, evaluationContext, listener);
    }

    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        try {
            ValueDescriptor parentDescriptor = builder.getParentDescriptor();
            EvaluationContext context = evaluationContext.createEvaluationContext(value);
            Value childrenValue = this.evaluateLocalVariablesNames(context);
            if (!(childrenValue instanceof ArrayReference)) {
                throw new EvaluateException("jruby returned non-array for local variable names");
            }
            ArrayReference array = (ArrayReference)childrenValue;
            int i = 0;
            ArrayList<DebuggerTreeNode> children = new ArrayList<DebuggerTreeNode>();
            for (Value nameValue : array.getValues()) {
                TextWithImportsImpl text = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "locals.getValues()[" + i + "]");
                String name = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)nameValue);
                UserExpressionData data = new UserExpressionData((ValueDescriptorImpl)parentDescriptor, "org.jruby.runtime.DynamicScope", name, (TextWithImports)text);
                UserExpressionDescriptor descriptor = builder.getDescriptorManager().getUserExpressionDescriptor((NodeDescriptor)parentDescriptor, (DescriptorData)data);
                children.add(nodeManager.createNode((NodeDescriptor)descriptor, context));
                ++i;
            }
            builder.setChildren(children);
        }
        catch (EvaluateException e) {
            ArrayList<DebuggerTreeNode> errorChildren = new ArrayList<DebuggerTreeNode>();
            errorChildren.add(nodeManager.createMessageNode(JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + e.getMessage()));
            builder.setChildren(errorChildren);
        }
    }

    private Value evaluateLocalVariablesNames(EvaluationContext context) throws EvaluateException {
        ExpressionEvaluator evaluator = this.myChildrenNameExpression.getEvaluator(context.getProject());
        return evaluator.evaluate(context);
    }

    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return ((ValueDescriptor)node.getDescriptor()).getDescriptorEvaluation(context);
    }

    public CompletableFuture<Boolean> isExpandableAsync(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return DebugProcessImpl.getDefaultRenderer((Value)value).isExpandableAsync(value, evaluationContext, parentDescriptor);
    }

    public String getUniqueId() {
        return UNIQUE_ID;
    }

    public boolean isApplicable(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        return type.name().startsWith(JRUBY_SCOPE_PACKAGE);
    }

    static class MyCachedEvaluator
    extends CachedEvaluator {
        MyCachedEvaluator() {
        }

        protected String getClassName() {
            return "java.lang.String";
        }

        public ExpressionEvaluator getEvaluator(Project project) throws EvaluateException {
            return super.getEvaluator(project);
        }
    }
}

