/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacet;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class JRubyProjectJdkTableListener
implements ProjectJdkTable.Listener {
    public void jdkRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            JRubyProjectJdkTableListener.$$$reportNull$$$0(0);
        }
        if (JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            JRubyProjectJdkTableListener.removeLibrary(sdk);
        }
    }

    public void jdkNameChanged(@NotNull Sdk sdk, @NotNull String previousName) {
        if (sdk == null) {
            JRubyProjectJdkTableListener.$$$reportNull$$$0(1);
        }
        if (previousName == null) {
            JRubyProjectJdkTableListener.$$$reportNull$$$0(2);
        }
        if (JRubySdkUtil.isJRubySDK((Sdk)sdk)) {
            JRubyProjectJdkTableListener.renameLibrary(sdk, previousName);
        }
    }

    private static void renameLibrary(Sdk sdk, String previousName) {
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
            LibraryTable.ModifiableModel libraryTableModel = GemModificationUtil.getLibraryTableModifiableModel();
            Library library = libraryTableModel.getLibraryByName(JRubyFacet.getFacetLibraryName(previousName));
            if (library != null) {
                Library.ModifiableModel model = library.getModifiableModel();
                model.setName(JRubyFacet.getFacetLibraryName(sdk.getName()));
                model.commit();
            }
            libraryTableModel.commit();
        }), ModalityState.nonModal());
    }

    private static void removeLibrary(Sdk sdk) {
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
            LibraryTable.ModifiableModel libraryTableModel = GemModificationUtil.getLibraryTableModifiableModel();
            Library library = libraryTableModel.getLibraryByName(JRubyFacet.getFacetLibraryName(sdk.getName()));
            if (library != null) {
                libraryTableModel.removeLibrary(library);
            }
            libraryTableModel.commit();
        }), ModalityState.nonModal());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/JRubyProjectJdkTableListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkRemoved";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkNameChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

