/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.java.jruby.types.JavaSymbolTypes;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RubyClassMember;
import org.jetbrains.plugins.ruby.ruby.codeInsight.OverriddenMethodGenerator;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class JRubyOverriddenMethodGenerator
extends OverriddenMethodGenerator {
    JRubyOverriddenMethodGenerator() {
    }

    public Type getSupportedType() {
        return JavaSymbolTypes.JAVA_METHOD;
    }

    @Nullable
    public String generateOverriddenMethod(ClassMember baseMember, @NotNull LanguageLevel languageLevel) {
        PsiElement baseElement;
        if (languageLevel == null) {
            JRubyOverriddenMethodGenerator.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = baseElement = baseMember instanceof PsiElementMemberChooserObject ? ((PsiElementMemberChooserObject)baseMember).getPsiElement() : null;
        if (baseElement instanceof PsiMethod) {
            PsiParameter[] parameters;
            PsiMethod baseMethod = (PsiMethod)baseElement;
            @NonNls StringBuilder text = new StringBuilder("def ");
            if (baseMethod.hasModifierProperty("static")) {
                text.append("self.");
            }
            boolean generateParenthesesAroundArguments = (parameters = baseMethod.getParameterList().getParameters()).length != 0 && RubyCodeStyleSettings.getInstance((PsiElement)baseElement).PARENTHESES_AROUND_METHOD_ARGUMENTS;
            text.append(NamingConventions.toUnderscoreCase((String)baseMethod.getName()));
            text.append(generateParenthesesAroundArguments ? "(" : " ");
            boolean first = true;
            for (PsiParameter param : parameters) {
                if (!first) {
                    text.append(", ");
                }
                first = false;
                text.append(JRubyOverriddenMethodGenerator.fixName(param.getName()));
            }
            String body = baseMethod.hasModifierProperty("abstract") ? "#code here" : "super";
            text.append(generateParenthesesAroundArguments ? ")" : "").append("\n  ").append(body).append("\nend");
            return text.toString();
        }
        return null;
    }

    public RubyClassMember createMemberToOverride(Symbol methodSymbol) {
        PsiMethod method;
        if (methodSymbol.getType() == JavaSymbolTypes.JAVA_METHOD && (method = (PsiMethod)methodSymbol.getPsiElement()) != null && PsiUtil.canBeOverridden((PsiMethod)method) && !method.hasModifierProperty("abstract")) {
            return new JRubyClassMember(method);
        }
        return null;
    }

    private static String fixName(String name) {
        for (IElementType kw : TokenBNF.kALL_KEYWORDS.getTypes()) {
            if (!kw.toString().equals(name)) continue;
            return name + "1";
        }
        return NamingConventions.toUnderscoreCase((String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/ruby/java/jruby/JRubyOverriddenMethodGenerator", "generateOverriddenMethod"));
    }

    private static final class JRubyClassMember
    extends PsiMethodMember
    implements RubyClassMember {
        private JRubyClassMember(@NotNull PsiMethod method) {
            if (method == null) {
                JRubyClassMember.$$$reportNull$$$0(0);
            }
            super(method);
        }

        @NotNull
        public String getLookupItemString() {
            String string = ((PsiMethod)this.getElement()).getName();
            if (string == null) {
                JRubyClassMember.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getContainerClassName() {
            PsiClass type = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
            String string = type == null ? "" : Objects.requireNonNullElse(type.getName(), "");
            if (string == null) {
                JRubyClassMember.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getPresentableParametersSignature() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/java/jruby/JRubyOverriddenMethodGenerator$JRubyClassMember";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/java/jruby/JRubyOverriddenMethodGenerator$JRubyClassMember";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupItemString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

