/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.java.jruby;

import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import org.jetbrains.plugins.ruby.java.jruby.JRubyAutoImportAction;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacet;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.RubyAutoImportProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;

public final class JRubyAutoImportProvider
implements RubyAutoImportProvider {
    public HintAction getAutoImportAction(RPsiElement unresolvedReferenceElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)unresolvedReferenceElement);
        if (module == null) {
            return null;
        }
        JRubyFacet facet = JRubyFacet.getInstance(module);
        if (facet == null || facet.getRubySdk() == null) {
            return null;
        }
        Project project = unresolvedReferenceElement.getProject();
        String text = unresolvedReferenceElement.getText();
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(text, scope);
        return classes.length > 0 ? new JRubyAutoImportAction(unresolvedReferenceElement, classes) : null;
    }
}

