/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.yaml.YAMLFileType;

public final class RailsYamlLanguageSubstitutor
extends LanguageSubstitutor {
    @Nullable
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        if (RailsYamlLanguageSubstitutor.isYmlConfigFile(file, project) && !RailsYamlLanguageSubstitutor.isWebpackerConfigFile(file, project)) {
            return ErbLanguage.INSTANCE;
        }
        return null;
    }

    private static boolean isWebpackerConfigFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        if (!file.getName().endsWith("webpacker.yml")) {
            return false;
        }
        RailsApp app = RailsApp.fromFile((Project)project, (VirtualFile)file);
        if (app == null) {
            return false;
        }
        return app.getPaths().findFiles("config", new String[]{"webpacker.yml"}).contains(file);
    }

    private static boolean isYmlConfigFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        if (project == null) {
            RailsYamlLanguageSubstitutor.$$$reportNull$$$0(5);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)YAMLFileType.YML)) {
            return false;
        }
        RailsApp app = RailsApp.fromFile((Project)project, (VirtualFile)file);
        if (app == null) {
            return false;
        }
        VirtualFile parent = file.getParent();
        if (parent != null && app.getPaths().findFiles("config").contains(parent)) {
            return true;
        }
        return ContainerUtil.exists((Iterable)app.getFixtureFileRoots(), root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/psi/RailsYamlLanguageSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isWebpackerConfigFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isYmlConfigFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

