/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.AssociationCallType;
import org.jetbrains.plugins.ruby.rails.fixtures.RailsFixturesUtils;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

final class RailsYamlFixturesRecordReference
extends PsiPolyVariantReferenceBase<YAMLScalar> {
    RailsYamlFixturesRecordReference(@NotNull YAMLScalar scalar, @NotNull TextRange range) {
        if (scalar == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)scalar, range);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!((YAMLScalar)this.myElement).isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        YAMLFile fixtureFile = (YAMLFile)ObjectUtils.tryCast((Object)((YAMLScalar)this.myElement).getContainingFile(), YAMLFile.class);
        if (fixtureFile == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)this.myElement);
        if (railsApp == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Module module = railsApp.getModule();
        RClass modelClass = RailsFixturesUtils.findModelByFixtureFile(module, fixtureFile);
        if (modelClass == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, YAMLKeyValue.class);
        if (keyValue == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        RCall association = RailsFixturesUtils.findAssociationByFixtureMapping(modelClass, keyValue);
        if (association == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String fullText = ((YAMLScalar)this.myElement).getTextValue();
        TextRange range = this.getRangeInElement();
        boolean isPolymorphic = AssociationCallType.isPolymorphic((RPossibleCall)association);
        if (isPolymorphic && RailsYamlFixturesRecordReference.isInsideParentheses(fullText, range)) {
            return RailsYamlFixturesRecordReference.resolveTypeInsideParentheses(module, fullText, range);
        }
        return RailsYamlFixturesRecordReference.resolveRecordReference(railsApp, module, fullText, range, association, isPolymorphic);
    }

    private static ResolveResult @NotNull [] resolveRecordReference(@NotNull RailsApp railsApp, @NotNull Module module, @NotNull String fullText, @NotNull TextRange range, @NotNull RCall association, boolean isPolymorphic) {
        String targetModelName;
        if (railsApp == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(8);
        }
        if (module == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(9);
        }
        if (fullText == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(10);
        }
        if (range == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(11);
        }
        if (association == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(12);
        }
        String string = targetModelName = isPolymorphic ? RailsYamlFixturesRecordReference.findTypeName(fullText, range.getEndOffset()) : (String)ObjectUtils.doIfNotNull((Object)AssociationsUtil.resolveToModel((RCall)association), PsiNamedElement::getName);
        if (StringUtil.isEmpty((String)targetModelName)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(13);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        YAMLFile targetFixtureFile = RailsFixturesUtils.findFixtureFile(railsApp, RailsFixturesUtils.pluralize(module, targetModelName.toLowerCase(Locale.ENGLISH)));
        if (targetFixtureFile == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                RailsYamlFixturesRecordReference.$$$reportNull$$$0(14);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String rangeText = range.substring(fullText);
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.findAll((Collection)YAMLUtil.getTopLevelKeys((YAMLFile)targetFixtureFile), kv -> rangeText.equals(kv.getKeyText())).stream().map(key -> new PsiElementResolveResult((PsiElement)key)).toArray(ResolveResult[]::new);
        if (resolveResultArray == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(15);
        }
        return resolveResultArray;
    }

    private static ResolveResult @NotNull [] resolveTypeInsideParentheses(@NotNull Module module, @NotNull String fullText, @NotNull TextRange range) {
        if (module == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(16);
        }
        if (fullText == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(17);
        }
        if (range == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(18);
        }
        String typeName = range.substring(fullText);
        FQN modelFqn = AssociationsUtil.classify((Module)module, (String)typeName);
        ResolveResult[] resolveResultArray = (ResolveResult[])RubyFQNUtil.findContainersByFQN((Project)module.getProject(), (TypeSet)Types.MODULE_OR_CLASS, (FQN)modelFqn, null).stream().map(container -> new PsiElementResolveResult((PsiElement)container)).toArray(ResolveResult[]::new);
        if (resolveResultArray == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(19);
        }
        return resolveResultArray;
    }

    @Nullable
    private static String findTypeName(@NotNull String value, int start) {
        int openParen;
        if (value == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(20);
        }
        if ((openParen = value.indexOf(40, start)) == -1) {
            return null;
        }
        int closeParen = value.indexOf(41, openParen);
        if (closeParen == -1) {
            return null;
        }
        return value.substring(openParen + 1, closeParen);
    }

    private static boolean isInsideParentheses(@NotNull String value, @NotNull TextRange range) {
        if (value == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(21);
        }
        if (range == null) {
            RailsYamlFixturesRecordReference.$$$reportNull$$$0(22);
        }
        int openParen = range.getStartOffset() - 1;
        int closeParen = range.getEndOffset();
        return openParen >= 0 && closeParen < value.length() && value.charAt(openParen) == '(' && value.charAt(closeParen) == ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 13, 14, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalar";
                break;
            }
            case 1: 
            case 11: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/fixtures/references/RailsYamlFixturesRecordReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "association";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/references/RailsYamlFixturesRecordReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRecordReference";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeInsideParentheses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveRecordReference";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeInsideParentheses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTypeName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsideParentheses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 13, 14, 15, 19 -> new IllegalStateException(string);
        };
    }
}

