/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures.indexes;

import com.intellij.lang.Language;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.util.YamlIndexUtil;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public final class YamlTopLevelKeysIndex
extends SingleEntryFileBasedIndexExtension<Set<String>> {
    public static final ID<Integer, Set<String>> KEY = ID.create((String)"yaml.top.level.keys.index");

    @NotNull
    public ID<Integer, Set<String>> getName() {
        ID<Integer, Set<String>> iD = KEY;
        if (iD == null) {
            YamlTopLevelKeysIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = YamlIndexUtil.EXPLICIT_YAML_FILTER;
        if (inputFilter == null) {
            YamlTopLevelKeysIndex.$$$reportNull$$$0(1);
        }
        return inputFilter;
    }

    @NotNull
    public SingleEntryIndexer<Set<String>> getIndexer() {
        return new SingleEntryIndexer<Set<String>>(this, false){

            @Nullable
            protected Set<String> computeValue(@NotNull FileContent inputData) {
                YAMLFile yamlFile;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)inputData.getPsiFile().getViewProvider().getPsi((Language)YAMLLanguage.INSTANCE), YAMLFile.class)) == null) {
                    return null;
                }
                return YAMLUtil.getTopLevelKeys((YAMLFile)yamlFile).stream().map(YAMLKeyValue::getKeyText).filter(recordName -> !recordName.contains("<%")).collect(Collectors.toSet());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/ruby/rails/fixtures/indexes/YamlTopLevelKeysIndex$1", "computeValue"));
            }
        };
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        return new StringCollectionExternalizer(HashSet::new);
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/rails/fixtures/indexes/YamlTopLevelKeysIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

