/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.fixtures.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.AssociationCallType;
import org.jetbrains.plugins.ruby.rails.fixtures.RailsFixturesUtils;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.psi.RailsTestFileFilter;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

final class RailsYamlFixturesRecordCompletionProvider
extends RubyTrackedCompletionProvider {
    private static final RailsYamlFixturesRecordCompletionProvider INSTANCE = new RailsYamlFixturesRecordCompletionProvider();
    static final PsiElementPattern.Capture<PsiElement> YAML_FIXTURE_VALUE_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(YAMLKeyValue.class)).inFile((ElementPattern)PlatformPatterns.psiFile(YAMLFile.class).and((ElementPattern)new FilterPattern((ElementFilter)new RailsTestFileFilter())));

    private RailsYamlFixturesRecordCompletionProvider() {
        super((Language)YAMLLanguage.INSTANCE);
    }

    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        YAMLFile fixtureFile;
        if (parameters == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((fixtureFile = (YAMLFile)ObjectUtils.tryCast((Object)(element = parameters.getPosition()).getContainingFile(), YAMLFile.class)) == null) {
            return;
        }
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)element);
        if (railsApp == null) {
            return;
        }
        Module module = railsApp.getModule();
        RClass modelClass = RailsFixturesUtils.findModelByFixtureFile(module, fixtureFile);
        if (modelClass == null) {
            return;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        if (keyValue == null) {
            return;
        }
        RCall association = RailsFixturesUtils.findAssociationByFixtureMapping(modelClass, keyValue);
        if (association == null) {
            return;
        }
        boolean isPolymorphic = AssociationCallType.isPolymorphic((RPossibleCall)association);
        for (RClass targetModelClass : AssociationsUtil.resolveToModels((RCall)association)) {
            YAMLFile targetFixtureFile;
            String targetModelName = targetModelClass.getName();
            if (StringUtil.isEmpty((String)targetModelName) || (targetFixtureFile = RailsFixturesUtils.findFixtureFile(railsApp, RailsFixturesUtils.pluralize(module, targetModelName.toLowerCase(Locale.ENGLISH)))) == null) continue;
            for (String recordLabel : RailsFixturesUtils.getRecordLabels(targetFixtureFile)) {
                RailsYamlFixturesRecordCompletionProvider.addRecordVariant(result, recordLabel, targetFixtureFile, isPolymorphic ? targetModelName : null);
            }
        }
    }

    private static void addRecordVariant(@NotNull CompletionResultSet result, @NotNull String value, @NotNull YAMLFile targetFixture, @Nullable String targetModelName) {
        if (result == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(3);
        }
        if (value == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(4);
        }
        if (targetFixture == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(5);
        }
        String targetModelSuffix = targetModelName != null ? " (" + targetModelName + ")" : null;
        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)value).withIcon(AllIcons.Nodes.EmptyNode).withTypeText(targetFixture.getVirtualFile().getPresentableName()).withTailText(targetModelSuffix).withInsertHandler((context, item) -> {
            if (targetModelSuffix == null) {
                return;
            }
            EditorModificationUtilEx.insertStringAtCaret((Editor)context.getEditor(), (String)targetModelSuffix);
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
        });
        result.addElement((LookupElement)lookupElement);
    }

    @NotNull
    public static RailsYamlFixturesRecordCompletionProvider getInstance() {
        RailsYamlFixturesRecordCompletionProvider railsYamlFixturesRecordCompletionProvider = INSTANCE;
        if (railsYamlFixturesRecordCompletionProvider == null) {
            RailsYamlFixturesRecordCompletionProvider.$$$reportNull$$$0(6);
        }
        return railsYamlFixturesRecordCompletionProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFixture";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/completion/RailsYamlFixturesRecordCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/fixtures/codeInsight/completion/RailsYamlFixturesRecordCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsTracked";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRecordVariant";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

