/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nTranslationKeysIndex;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nYAMLPossibleLocaleIndex;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nYAMLTranslationIndex;
import org.jetbrains.plugins.ruby.i18n.locales.YamlKeyFakePsiElement;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

public final class I18nYAMLAdapter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final String myLocaleName;

    public I18nYAMLAdapter(@NotNull YAMLFile yamlFile) {
        if (yamlFile == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(0);
        }
        this.myProject = yamlFile.getProject();
        this.myVirtualFile = yamlFile.getVirtualFile();
        this.myLocaleName = (String)ReadAction.compute(() -> this.calculateLocale());
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Nullable
    public YAMLFile getPsiFile() {
        return (YAMLFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile), YAMLFile.class);
    }

    @NotNull
    public String getLocale() {
        String string = this.myLocaleName;
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String calculateLocale() {
        List localesFromThisFile = Objects.requireNonNullElse((List)FileBasedIndex.getInstance().getSingleEntryIndexData(I18nYAMLPossibleLocaleIndex.KEY, this.myVirtualFile, this.myProject), Collections.emptyList());
        String string = localesFromThisFile.size() == 1 ? (String)localesFromThisFile.get(0) : this.myVirtualFile.getNameWithoutExtension();
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiElement getRecord(@NotNull String k) {
        if (k == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(4);
        }
        Object[] fullKey = this.getFullRecordPath(k);
        String thisLocalePath = String.join((CharSequence)".", (CharSequence[])fullKey);
        String keyText = (String)ArrayUtil.getLastElement((Object[])fullKey);
        String translation = (String)FileBasedIndex.getInstance().getFileData(I18nYAMLTranslationIndex.KEY, this.myVirtualFile, this.myProject).get(thisLocalePath);
        if (translation == null) {
            return null;
        }
        YAMLFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        return new YamlKeyFakePsiElement(psiFile, thisLocalePath, StringUtil.notNullize((String)keyText, (String)k));
    }

    @NotNull
    public List<String> getAllKeys() {
        List list = (List)ReadAction.compute(() -> Objects.requireNonNullElse((List)FileBasedIndex.getInstance().getSingleEntryIndexData(I18nTranslationKeysIndex.KEY, this.myVirtualFile, this.myProject), Collections.emptyList()));
        if (list == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public YAMLKeyValue createI18nRecord(@NotNull String k, @NotNull String text) {
        YAMLFile yamlFile;
        if (k == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(6);
        }
        if (text == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(7);
        }
        if ((yamlFile = this.getPsiFile()) == null) {
            return null;
        }
        String[] fullKey = this.getFullRecordPath(k);
        String formatedText = StringUtil.wrapWithDoubleQuote((String)text.trim().replaceAll("\\s+", " "));
        YAMLKeyValue record = YAMLUtil.getQualifiedKeyInFile((YAMLFile)yamlFile, (String[])fullKey);
        YAMLFile dummyFile = YAMLElementGenerator.getInstance((Project)this.myProject).createDummyYamlWithText(formatedText);
        YAMLValue topLevelValue = ((YAMLDocument)dummyFile.getDocuments().get(0)).getTopLevelValue();
        if (topLevelValue != null && record != null) {
            record.setValue(topLevelValue);
            return record;
        }
        return YAMLUtil.createI18nRecord((YAMLFile)yamlFile, (String[])fullKey, (String)formatedText);
    }

    public static boolean isTranslationElement(@Nullable PsiElement element) {
        return (Boolean)ReadAction.compute(() -> {
            if (element instanceof YamlKeyFakePsiElement) {
                return true;
            }
            if (!(element instanceof YAMLKeyValue && element.isValid() && I18nProvider.isLocaleFile((PsiFile)element.getContainingFile()))) {
                return false;
            }
            return I18nYAMLAdapter.getTranslation(element) != null;
        });
    }

    @Contract(value="null -> null")
    @Nullable
    @NlsSafe
    public static String getTranslation(@Nullable PsiElement element) {
        PsiFile file;
        String path;
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
            path = YAMLUtil.getConfigFullName((YAMLPsiElement)yamlKeyValue);
            file = yamlKeyValue.getContainingFile();
        } else if (element instanceof YamlKeyFakePsiElement) {
            YamlKeyFakePsiElement fake = (YamlKeyFakePsiElement)element;
            path = fake.getFullKeyPath();
            file = fake.getYamlFile();
        } else {
            return null;
        }
        return (String)ReadAction.compute(() -> (String)FileBasedIndex.getInstance().getFileData(I18nYAMLTranslationIndex.KEY, file.getVirtualFile(), file.getProject()).get(path));
    }

    @NotNull
    public static String getI18nKeyPath(@NotNull PsiElement element) {
        String fullPath;
        if (element == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(8);
        }
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
            fullPath = YAMLUtil.getConfigFullName((YAMLPsiElement)yamlKeyValue);
        } else if (element instanceof YamlKeyFakePsiElement) {
            YamlKeyFakePsiElement fake = (YamlKeyFakePsiElement)element;
            fullPath = fake.getFullKeyPath();
        } else {
            return "";
        }
        String string = StringUtil.notNullize((String)StringUtil.substringAfter((String)fullPath, (String)"."));
        if (string == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private String @NotNull [] getFullRecordPath(@NotNull String keyStr) {
        if (keyStr == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(10);
        }
        Object[] key = keyStr.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : keyStr.split("\\.");
        String[] stringArray = (String[])ArrayUtil.prepend((Object)this.myLocaleName, (Object[])key);
        if (stringArray == null) {
            I18nYAMLAdapter.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/locales/I18nYAMLAdapter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/locales/I18nYAMLAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLocale";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getI18nKeyPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullRecordPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRecord";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createI18nRecord";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getI18nKeyPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFullRecordPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 9, 11 -> new IllegalStateException(string);
        };
    }
}

