/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public final class I18nYAMLAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        YAMLFile yamlFile;
        if (psiElement == null) {
            I18nYAMLAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            I18nYAMLAnnotator.$$$reportNull$$$0(1);
        }
        if ((yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)psiElement, YAMLFile.class)) != null && I18nProvider.isLocaleFile((PsiFile)yamlFile)) {
            yamlFile.accept((PsiElementVisitor)new MyVisitor(holder));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/i18n/annotator/I18nYAMLAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVisitor
    extends YamlRecursivePsiElementVisitor {
        private final AnnotationHolder myHolder;
        private PsiFile myFile;
        private int myDocumentCount;

        private MyVisitor(@NotNull AnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myDocumentCount = 0;
            this.myHolder = holder;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myFile = psiFile;
            super.visitFile(psiFile);
            if (this.myDocumentCount == 0) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotator.rails.i18n.locale.file.no.root")).create();
            }
        }

        public void visitDocument(@NotNull YAMLDocument document) {
            YAMLValue topLevelValue;
            if (document == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            super.visitDocument(document);
            if (++this.myDocumentCount > 1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotator.rails.i18n.locale.file.multiple.roots")).range(PsiTreeUtil.getDeepestFirst((PsiElement)document)).create();
            }
            if ((topLevelValue = document.getTopLevelValue()) instanceof YAMLMapping) {
                ArrayList keyValues = new ArrayList(((YAMLMapping)topLevelValue).getKeyValues());
                YAMLKeyValue rootKeyValue = (YAMLKeyValue)ContainerUtil.getFirstItem(keyValues);
                if (rootKeyValue != null && !this.myFile.getName().contains(rootKeyValue.getKeyText())) {
                    this.myHolder.newAnnotation(HighlightSeverity.WARNING, RBundle.message((String)"annotator.rails.i18n.locale.file.name", (Object[])new Object[]{rootKeyValue.getKeyText()})).range(PsiTreeUtil.getDeepestFirst((PsiElement)rootKeyValue)).create();
                }
                if (keyValues.size() > 1) {
                    keyValues.subList(1, keyValues.size()).forEach(keyValue -> this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotator.rails.i18n.locale.file.multiple.roots")).range(PsiTreeUtil.getDeepestFirst((PsiElement)keyValue)).create());
                }
            } else {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotator.rails.i18n.locale.file.no.root")).range(PsiTreeUtil.getDeepestFirst((PsiElement)document)).create();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/annotator/I18nYAMLAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDocument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

