/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.indexes.I18nTranslationKeysIndex;
import org.jetbrains.plugins.ruby.i18n.locales.I18nYAMLAdapter;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.locales.YAMLLocaleEntry;
import org.jetbrains.plugins.ruby.i18n.locales.YamlKeyFakePsiElement;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.RubyI18nSafeDeleteSupport;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.YamlI18nSafeDeleteSupport;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public final class YamlI18nProvider
extends I18nProvider {
    @NotNull
    public LocaleEntry createLocaleEntry(@NotNull PsiFile psiFile, @NotNull String localesRootPath) {
        if (psiFile == null) {
            YamlI18nProvider.$$$reportNull$$$0(0);
        }
        if (localesRootPath == null) {
            YamlI18nProvider.$$$reportNull$$$0(1);
        }
        if (!(psiFile instanceof YAMLFile)) {
            throw new IllegalArgumentException();
        }
        return new YAMLLocaleEntry((YAMLFile)psiFile, localesRootPath);
    }

    @NotNull
    public @Unmodifiable List<?> getDictionaryDependencies(@NotNull Module module) {
        if (module == null) {
            YamlI18nProvider.$$$reportNull$$$0(2);
        }
        Project project = module.getProject();
        List list = ContainerUtil.append((List)RubyModificationTrackers.getRailsSettingsModificationTrackers((Project)project, (Module)module), (Object[])new Object[]{() -> FileBasedIndex.getInstance().getIndexModificationStamp(I18nTranslationKeysIndex.KEY, project)});
        if (list == null) {
            YamlI18nProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isTranslationElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlI18nProvider.$$$reportNull$$$0(4);
        }
        return I18nYAMLAdapter.isTranslationElement(element);
    }

    @Nullable
    public String getTranslation(@Nullable PsiElement element) {
        return I18nYAMLAdapter.getTranslation(element);
    }

    @Nullable
    public String getKeyText(@Nullable PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return null;
    }

    @Nullable
    public PsiElement getKeyElement(@Nullable PsiElement element) {
        return element;
    }

    @Nullable
    public String getFullKey(@Nullable PsiElement element) {
        return I18nYAMLAdapter.getI18nKeyPath(element);
    }

    public boolean canBeTranslationReferenceTarget(@NotNull PsiElement element) {
        if (element == null) {
            YamlI18nProvider.$$$reportNull$$$0(5);
        }
        return element instanceof YAMLKeyValue || element instanceof YamlKeyFakePsiElement;
    }

    @NotNull
    public RubyI18nSafeDeleteSupport createSafeDeleteSupport() {
        RubyI18nSafeDeleteSupport rubyI18nSafeDeleteSupport = YamlI18nSafeDeleteSupport.INSTANCE;
        if (rubyI18nSafeDeleteSupport == null) {
            YamlI18nProvider.$$$reportNull$$$0(6);
        }
        return rubyI18nSafeDeleteSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localesRootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/YamlI18nProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/YamlI18nProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionaryDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeDeleteSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLocaleEntry";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryDependencies";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTranslationElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeTranslationReferenceTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

