/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.internal.EnumsKt;
import org.jetbrains.annotations.NotNull;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/ViewFilter;", "", "<init>", "(Ljava/lang/String;I)V", "HAS_ANY_VIEW", "HAS_LAYOUTS", "HAS_PARTIAL_VIEW", "HAS_NON_PARTIAL_VIEW", "HAS_NO_VIEW", "apply", "", "nonPartialViews", "", "", "partialViews", "layouts", "Companion", "intellij.ruby.mcp"})
public final class ViewFilter
extends Enum<ViewFilter> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String DESCRIPTION = "\n      |Filter entries based on whether they have a corresponding Rails view file.\n      |\n      |Options:\n      | - HAS_ANY_VIEW: Return only entries that have a corresponding view file (e.g., index.html.erb, _upload.json.jbuilder)\n      | - HAS_PARTIAL_VIEW: Return only entries that have a corresponding partial view file (e.g., _form.html.erb, _list.json.jbuilder)\n      | - HAS_NON_PARTIAL_VIEW: Return only entries that have a corresponding non-partial view file (e.g., index.html.erb, show.json.jbuilder)\n      | - HAS_LAYOUTS: Return only entries that have a corresponding layout file\n      | - HAS_NO_VIEW: Return only entries that do NOT have a corresponding view file\n    ";
    @NotNull
    private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate;
    public static final /* enum */ ViewFilter HAS_ANY_VIEW;
    public static final /* enum */ ViewFilter HAS_LAYOUTS;
    public static final /* enum */ ViewFilter HAS_PARTIAL_VIEW;
    public static final /* enum */ ViewFilter HAS_NON_PARTIAL_VIEW;
    public static final /* enum */ ViewFilter HAS_NO_VIEW;
    private static final /* synthetic */ ViewFilter[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public final boolean apply(@NotNull List<String> nonPartialViews, @NotNull List<String> partialViews, @NotNull List<String> layouts) {
        Intrinsics.checkNotNullParameter(nonPartialViews, (String)"nonPartialViews");
        Intrinsics.checkNotNullParameter(partialViews, (String)"partialViews");
        Intrinsics.checkNotNullParameter(layouts, (String)"layouts");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> {
                if (!((Collection)nonPartialViews).isEmpty() || !((Collection)partialViews).isEmpty() || !((Collection)layouts).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!((Collection)layouts).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (!((Collection)partialViews).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (!((Collection)nonPartialViews).isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (nonPartialViews.isEmpty() && partialViews.isEmpty() && layouts.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static ViewFilter[] values() {
        return (ViewFilter[])$VALUES.clone();
    }

    public static ViewFilter valueOf(String value) {
        return Enum.valueOf(ViewFilter.class, value);
    }

    @NotNull
    public static EnumEntries<ViewFilter> getEntries() {
        return $ENTRIES;
    }

    static {
        HAS_ANY_VIEW = new ViewFilter();
        HAS_LAYOUTS = new ViewFilter();
        HAS_PARTIAL_VIEW = new ViewFilter();
        HAS_NON_PARTIAL_VIEW = new ViewFilter();
        HAS_NO_VIEW = new ViewFilter();
        $VALUES = viewFilterArray = new ViewFilter[]{ViewFilter.HAS_ANY_VIEW, ViewFilter.HAS_LAYOUTS, ViewFilter.HAS_PARTIAL_VIEW, ViewFilter.HAS_NON_PARTIAL_VIEW, ViewFilter.HAS_NO_VIEW};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.intellij.ruby.mcp.util.filtering.ViewFilter", (Enum[])ViewFilter.values()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/ViewFilter$Companion;", "", "<init>", "()V", "DESCRIPTION", "", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ruby/mcp/util/filtering/ViewFilter;", "intellij.ruby.mcp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ViewFilter> serializer() {
            return this.get$cachedSerializer();
        }

        private final /* synthetic */ KSerializer get$cachedSerializer() {
            return (KSerializer)$cachedSerializer$delegate.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ViewFilter.values().length];
            try {
                nArray[ViewFilter.HAS_ANY_VIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewFilter.HAS_LAYOUTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewFilter.HAS_PARTIAL_VIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewFilter.HAS_NON_PARTIAL_VIEW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ViewFilter.HAS_NO_VIEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

