/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import com.intellij.ruby.mcp.util.RubySymbolInfo;
import com.intellij.ruby.mcp.util.filtering.FQNFilter;
import com.intellij.ruby.mcp.util.filtering.PathFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/SymbolInfoFilter;", "", "fqnFilter", "Lcom/intellij/ruby/mcp/util/filtering/FQNFilter;", "pathFilter", "Lcom/intellij/ruby/mcp/util/filtering/PathFilter;", "<init>", "(Lcom/intellij/ruby/mcp/util/filtering/FQNFilter;Lcom/intellij/ruby/mcp/util/filtering/PathFilter;)V", "getFqnFilter", "()Lcom/intellij/ruby/mcp/util/filtering/FQNFilter;", "getPathFilter", "()Lcom/intellij/ruby/mcp/util/filtering/PathFilter;", "apply", "", "symbol", "Lcom/intellij/ruby/mcp/util/RubySymbolInfo;", "intellij.ruby.mcp"})
public final class SymbolInfoFilter {
    @NotNull
    private final FQNFilter fqnFilter;
    @NotNull
    private final PathFilter pathFilter;

    public SymbolInfoFilter(@NotNull FQNFilter fqnFilter, @NotNull PathFilter pathFilter) {
        Intrinsics.checkNotNullParameter((Object)fqnFilter, (String)"fqnFilter");
        Intrinsics.checkNotNullParameter((Object)pathFilter, (String)"pathFilter");
        this.fqnFilter = fqnFilter;
        this.pathFilter = pathFilter;
    }

    @NotNull
    public final FQNFilter getFqnFilter() {
        return this.fqnFilter;
    }

    @NotNull
    public final PathFilter getPathFilter() {
        return this.pathFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean apply(@Nullable RubySymbolInfo symbol) {
        RubySymbolInfo rubySymbolInfo = symbol;
        if (!this.fqnFilter.apply(rubySymbolInfo != null ? rubySymbolInfo.getFqn() : null)) return false;
        RubySymbolInfo rubySymbolInfo2 = symbol;
        if (!this.pathFilter.apply(rubySymbolInfo2 != null ? rubySymbolInfo2.getFilePath() : null)) return false;
        return true;
    }
}

