/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import com.intellij.ruby.mcp.toolsets.RailsToolset;
import com.intellij.ruby.mcp.util.filtering.HTTPMethodFilter;
import com.intellij.ruby.mcp.util.filtering.SymbolInfoFilter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.UIntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/RouteActionsFilter;", "", "symbolInfoFilter", "Lcom/intellij/ruby/mcp/util/filtering/SymbolInfoFilter;", "httpMethodFilter", "Lcom/intellij/ruby/mcp/util/filtering/HTTPMethodFilter;", "actionCount", "Lkotlin/ranges/UIntRange;", "<init>", "(Lcom/intellij/ruby/mcp/util/filtering/SymbolInfoFilter;Lcom/intellij/ruby/mcp/util/filtering/HTTPMethodFilter;Lkotlin/ranges/UIntRange;)V", "getSymbolInfoFilter", "()Lcom/intellij/ruby/mcp/util/filtering/SymbolInfoFilter;", "getHttpMethodFilter", "()Lcom/intellij/ruby/mcp/util/filtering/HTTPMethodFilter;", "getActionCount", "()Lkotlin/ranges/UIntRange;", "apply", "", "actions", "", "Lcom/intellij/ruby/mcp/toolsets/RailsToolset$RailsRouteAction;", "Companion", "intellij.ruby.mcp"})
@SourceDebugExtension(value={"SMAP\nBidirectionalFilteringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BidirectionalFilteringUtils.kt\ncom/intellij/ruby/mcp/util/filtering/RouteActionsFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1761#2,3:191\n*S KotlinDebug\n*F\n+ 1 BidirectionalFilteringUtils.kt\ncom/intellij/ruby/mcp/util/filtering/RouteActionsFilter\n*L\n166#1:191,3\n*E\n"})
public final class RouteActionsFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SymbolInfoFilter symbolInfoFilter;
    @NotNull
    private final HTTPMethodFilter httpMethodFilter;
    @NotNull
    private final UIntRange actionCount;
    public static final int MIN_ACTION_COUNT_DEFAULT = 0;
    @NotNull
    public static final String MIN_ACTION_COUNT_DESCRIPTION = "\n      |Minimum number of distinct controller actions a route must map to (inclusive). \n      |A single route path may map to multiple actions via different HTTP methods.\n      |For example, '/users/:id' might have GET (show), PUT (update), and DELETE (destroy) actions. \n      |\n      |Default: 0 (no minimum)\n    ";
    public static final int MAX_ACTION_COUNT_DEFAULT = -1;
    @NotNull
    public static final String MAX_ACTION_COUNT_DESCRIPTION = "\n      |Maximum number of distinct controller actions a route can map to (inclusive). \n      |A single route path may map to multiple actions via different HTTP methods. \n      |Set this to filter out routes with too many actions. \n      |\n      |Default: 4294967295 (no maximum)\n    ";

    public RouteActionsFilter(@NotNull SymbolInfoFilter symbolInfoFilter, @NotNull HTTPMethodFilter httpMethodFilter, @NotNull UIntRange actionCount) {
        Intrinsics.checkNotNullParameter((Object)symbolInfoFilter, (String)"symbolInfoFilter");
        Intrinsics.checkNotNullParameter((Object)httpMethodFilter, (String)"httpMethodFilter");
        Intrinsics.checkNotNullParameter((Object)actionCount, (String)"actionCount");
        this.symbolInfoFilter = symbolInfoFilter;
        this.httpMethodFilter = httpMethodFilter;
        this.actionCount = actionCount;
    }

    @NotNull
    public final SymbolInfoFilter getSymbolInfoFilter() {
        return this.symbolInfoFilter;
    }

    @NotNull
    public final HTTPMethodFilter getHttpMethodFilter() {
        return this.httpMethodFilter;
    }

    @NotNull
    public final UIntRange getActionCount() {
        return this.actionCount;
    }

    public final boolean apply(@NotNull List<RailsToolset.RailsRouteAction> actions) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            UIntRange uIntRange = this.actionCount;
            int n = uIntRange.getFirst-pVg5ArA();
            int n2 = uIntRange.getLast-pVg5ArA();
            int n3 = UInt.constructor-impl((int)((Collection)actions).size());
            if (!(0 <= UnsignedKt.uintCompare((int)n3, (int)n) ? UnsignedKt.uintCompare((int)n3, (int)n2) <= 0 : false)) {
                return false;
            }
            if (actions.isEmpty()) {
                return !this.httpMethodFilter.hasIncludeFilters() && !this.symbolInfoFilter.getFqnFilter().hasIncludeFilters() && !this.symbolInfoFilter.getPathFilter().hasIncludeFilters();
            }
            Iterable $this$any$iv = actions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RailsToolset.RailsRouteAction action = (RailsToolset.RailsRouteAction)element$iv;
                    boolean bl2 = false;
                    if (!(this.symbolInfoFilter.apply(action.getHandler()) || this.httpMethodFilter.apply(action.getHttpMethod()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/RouteActionsFilter$Companion;", "", "<init>", "()V", "MIN_ACTION_COUNT_DEFAULT", "Lkotlin/UInt;", "I", "MIN_ACTION_COUNT_DESCRIPTION", "", "MAX_ACTION_COUNT_DEFAULT", "MAX_ACTION_COUNT_DESCRIPTION", "intellij.ruby.mcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

