/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import com.intellij.ruby.mcp.util.filtering.BidirectionalPatternMatchingFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0001\bB%\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/PathFilter;", "Lcom/intellij/ruby/mcp/util/filtering/BidirectionalPatternMatchingFilter;", "include", "", "", "exclude", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "Companion", "intellij.ruby.mcp"})
public final class PathFilter
extends BidirectionalPatternMatchingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INCLUDED_DESCRIPTION = "\n      |Filter paths with regular expressions (case insensitive, tested against the entire path using find semantics, \n      |like matches anywhere in the string). The path can be any path including a URL or an absolute filepath. Returns \n      |only symbols whose absolute path contains a match of at least one (OR logic) of these regular expressions. Since \n      |the full path includes the filename and extension, you can filter by file format  (e.g., '.erb', '.txt', '.rb').\n      |Invalid patterns are ignored. \n      |\n      |COMMON PATTERNS:\n      |  - Include directory: ['/views/'] includes any path that contains a 'views' directory.\n      |  - Include file in directory: ['/views/', '.erb'] includes every '.erb' file in a 'views' directory.\n      |  - Include file extension: [\".rb\", \".erb\"] includes all Ruby and ERB files.\n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n    ";
    @NotNull
    public static final String EXCLUDED_DESCRIPTION = "\n      |Filter paths with regular expressions (case insensitive, tested against the entire path using find semantics, \n      |like matches anywhere in the string). The path can be any path including a URL or an absolute filepath. Returns \n      |only symbols whose absolute path contains a match of at least one (OR logic) of these regular expressions. Since \n      |the full path includes the filename and extension, you can filter by file format (e.g., '.erb', '.txt', '.rb').\n      |Invalid patterns are ignored. \n      |\n      |COMMON PATTERNS:\n      |  - Exclude directories: ['/test/', '/spec/'] excludes any path that contains any of the listed directories.\n      |  - Exclude file in directory: ['/test/', '.txt'] excludes every '.txt' file in the 'test' directory.\n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n  ";

    public PathFilter(@NotNull List<String> include, @NotNull List<String> exclude) {
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        super(include, exclude, SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/PathFilter$Companion;", "", "<init>", "()V", "INCLUDED_DESCRIPTION", "", "EXCLUDED_DESCRIPTION", "intellij.ruby.mcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

