/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import com.intellij.ruby.mcp.toolsets.RailsToolset;
import com.intellij.ruby.mcp.util.filtering.BidirectionalFilter;
import com.intellij.ruby.mcp.util.filtering.ViewFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \t2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/IncludedViewsFilter;", "Lcom/intellij/ruby/mcp/util/filtering/BidirectionalFilter;", "Lcom/intellij/ruby/mcp/util/filtering/ViewFilter;", "Lcom/intellij/ruby/mcp/toolsets/RailsToolset$RailsControllerInfo;", "include", "", "exclude", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "Companion", "intellij.ruby.mcp"})
public final class IncludedViewsFilter
extends BidirectionalFilter<ViewFilter, RailsToolset.RailsControllerInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INCLUDED_DESCRIPTION = "\n      |Filter controllers based on their associated views. Returns controllers that have at least one view matching ANY of these filters (OR logic).\n      |A view filter is defined as follows: '\n      |Filter entries based on whether they have a corresponding Rails view file.\n      |\n      |Options:\n      | - HAS_ANY_VIEW: Return only entries that have a corresponding view file (e.g., index.html.erb, _upload.json.jbuilder)\n      | - HAS_PARTIAL_VIEW: Return only entries that have a corresponding partial view file (e.g., _form.html.erb, _list.json.jbuilder)\n      | - HAS_NON_PARTIAL_VIEW: Return only entries that have a corresponding non-partial view file (e.g., index.html.erb, show.json.jbuilder)\n      | - HAS_LAYOUTS: Return only entries that have a corresponding layout file\n      | - HAS_NO_VIEW: Return only entries that do NOT have a corresponding view file\n    '.\n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n    ";
    @NotNull
    public static final String EXCLUDED_DESCRIPTION = "\n      |Filter controllers based on their associated views. Returns only controllers that do NOT have any views matched by ANY of these \n      |filters (OR logic). A view filter is defined as follows: '\n      |Filter entries based on whether they have a corresponding Rails view file.\n      |\n      |Options:\n      | - HAS_ANY_VIEW: Return only entries that have a corresponding view file (e.g., index.html.erb, _upload.json.jbuilder)\n      | - HAS_PARTIAL_VIEW: Return only entries that have a corresponding partial view file (e.g., _form.html.erb, _list.json.jbuilder)\n      | - HAS_NON_PARTIAL_VIEW: Return only entries that have a corresponding non-partial view file (e.g., index.html.erb, show.json.jbuilder)\n      | - HAS_LAYOUTS: Return only entries that have a corresponding layout file\n      | - HAS_NO_VIEW: Return only entries that do NOT have a corresponding view file\n    '.\n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n    ";

    public IncludedViewsFilter(@NotNull List<? extends ViewFilter> include, @NotNull List<? extends ViewFilter> exclude) {
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        super(include, exclude, IncludedViewsFilter::_init_$lambda$0);
    }

    private static final boolean _init_$lambda$0(ViewFilter filter, RailsToolset.RailsControllerInfo info) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return filter.apply(info.getManagedViews(), info.getManagedPartialViews(), info.getManagedLayouts());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/IncludedViewsFilter$Companion;", "", "<init>", "()V", "INCLUDED_DESCRIPTION", "", "EXCLUDED_DESCRIPTION", "intellij.ruby.mcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

