/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util.filtering;

import com.intellij.ruby.mcp.toolsets.RailsToolset;
import com.intellij.ruby.mcp.util.filtering.BidirectionalFilter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/HTTPMethodFilter;", "Lcom/intellij/ruby/mcp/util/filtering/BidirectionalFilter;", "Lcom/intellij/ruby/mcp/toolsets/RailsToolset$HTTPMethod;", "include", "", "exclude", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "Companion", "intellij.ruby.mcp"})
public final class HTTPMethodFilter
extends BidirectionalFilter<RailsToolset.HTTPMethod, RailsToolset.HTTPMethod> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INCLUDED_DESCRIPTION = "\n      |Filter objects by corresponding HTTP methods. Only objects that respond to at least one of these HTTP methods will be returned. \n      |Example: [GET, POST] would return objects that handle GET or POST requests. \n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n    ";
    @NotNull
    public static final String EXCLUDED_DESCRIPTION = "\n      |Filter objects by corresponding HTTP methods. Only objects that do NOT respond to any of these HTTP methods will be returned. \n      |Example: [GET, POST] would return objects that do NOT handle GET or POST requests. \n      |\n      |This parameter supports bulk filtering. Prefer this over multiple individual calls for efficiency and reduced tool call count. Can be empty to skip filtering. If both included and excluded filters are specified, excluded filters take precedence. By default no filter is applied.\n    ";

    public HTTPMethodFilter(@NotNull List<? extends RailsToolset.HTTPMethod> include, @NotNull List<? extends RailsToolset.HTTPMethod> exclude) {
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        super(include, exclude, HTTPMethodFilter::_init_$lambda$0);
    }

    private static final boolean _init_$lambda$0(RailsToolset.HTTPMethod filter, RailsToolset.HTTPMethod value) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return filter == value;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ruby/mcp/util/filtering/HTTPMethodFilter$Companion;", "", "<init>", "()V", "INCLUDED_DESCRIPTION", "", "EXCLUDED_DESCRIPTION", "intellij.ruby.mcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

