/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.ruby.mcp.util.RubySymbolInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getSymbolInfo", "Lcom/intellij/ruby/mcp/util/RubySymbolInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "item", "Lorg/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/RElementWithFQN;", "intellij.ruby.mcp"})
public final class RubySymbolUtilsKt {
    @Nullable
    public static final RubySymbolInfo getSymbolInfo(@NotNull VirtualFile file, @NotNull RElementWithFQN item) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int offset = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)item));
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        int line = document.getLineNumber(offset);
        int column = offset - document.getLineStartOffset(line);
        return new RubySymbolInfo(item.getFQNWithNesting().toString(), filePath, line + 1, column + 1);
    }
}

