/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.mcp.util;

import com.intellij.mcpserver.McpToolKt;
import com.intellij.ruby.mcp.util.PageData;
import com.intellij.ruby.mcp.util.PageSummary;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a>\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\r0\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"PAGE_NUMBER_DESCRIPTION", "", "PAGE_SIZE_DESCRIPTION", "withPagination", "Lcom/intellij/ruby/mcp/util/PageData;", "T", "page", "", "page_size", "timestamp", "", "block", "Lkotlin/Function0;", "", "intellij.ruby.mcp"})
public final class PaginationUtilsKt {
    @NotNull
    public static final String PAGE_NUMBER_DESCRIPTION = "The number of the page to retrieve, indexed from 1.";
    @NotNull
    public static final String PAGE_SIZE_DESCRIPTION = "The maximum number of items to return per page.";

    @NotNull
    public static final <T> PageData<T> withPagination(int page, int page_size, long timestamp, @NotNull Function0<? extends List<? extends T>> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (page_size <= 0) {
            McpToolKt.mcpFail$default((String)("Invalid page_size '" + page_size + "'. Specify a page_size greater than 0. The page_size parameter controls how many items are returned per page."), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        List data = (List)block.invoke();
        int totalPages = Math.max(1, data.size() / page_size + (data.size() % page_size == 0 ? 0 : 1));
        if (!(1 <= page ? page <= totalPages : false)) {
            McpToolKt.mcpFail$default((String)("Page number '" + page + "' is out of range. Specify a page number between 1 and " + totalPages + "."), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        List items = data.subList((page - 1) * page_size, Math.min(page * page_size, data.size()));
        PageSummary summary = new PageSummary(page, items.size(), totalPages, data.size(), String.valueOf(timestamp));
        return new PageData(summary, items);
    }
}

