/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.microservices.url;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;

public final class RailsRouteUrlTargetInfo
implements UrlTargetInfo {
    public static final List<Authority> DEFAULT_AUTHORITIES = List.of(new Authority.Exact("localhost:3000"), new Authority.Exact("localhost:8080"), new Authority.Exact("localhost"));
    public static final List<String> DEFAULT_SCHEMES = UrlConstants.HTTP_SCHEMES;
    private final UrlPath myPath;
    private final Set<String> myMethods;
    private final String mySource;
    private final SmartPsiElementPointer<?> myElementPointer;

    RailsRouteUrlTargetInfo(@NotNull UrlPath path, @NotNull Set<String> methods, @NotNull String source, @NotNull SmartPsiElementPointer<?> elementPointer) {
        if (path == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(0);
        }
        if (methods == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(1);
        }
        if (source == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(2);
        }
        if (elementPointer == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(3);
        }
        this.myPath = path;
        this.myMethods = Set.copyOf(methods);
        this.mySource = source;
        this.myElementPointer = elementPointer;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        List<Authority> list = DEFAULT_AUTHORITIES;
        if (list == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Rails.Endpoint;
        if (icon == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public Set<String> getMethods() {
        Set<String> set = this.myMethods;
        if (set == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public UrlPath getPath() {
        UrlPath urlPath = this.myPath;
        if (urlPath == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(7);
        }
        return urlPath;
    }

    @NotNull
    public List<String> getSchemes() {
        List<String> list = DEFAULT_SCHEMES;
        if (list == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public String getSource() {
        String string = this.mySource;
        if (string == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.myElementPointer.getElement();
    }

    @NotNull
    public static Collection<RailsRouteUrlTargetInfo> createFromRoutes(@NotNull Map<PsiElement, List<RailsRoute>> data) {
        if (data == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(10);
        }
        ArrayList<RailsRouteUrlTargetInfo> infos = new ArrayList<RailsRouteUrlTargetInfo>();
        data.forEach((element, routes) -> routes.stream().filter(it -> it.getVerb() != null && it.getPath() != null).collect(Collectors.groupingBy(it -> new Pair((Object)it.getPath(), (Object)it.getTarget().getCallerFQN().getFullPath()))).entrySet().stream().map(entry -> {
            UrlPath path = (UrlPath)((Pair)entry.getKey()).getFirst();
            String source = (String)((Pair)entry.getKey()).getSecond();
            Set methods = ContainerUtil.map2Set((Collection)((Collection)entry.getValue()), RailsRoute::getVerb);
            return new RailsRouteUrlTargetInfo(path, methods, source, SmartPointerManager.createPointer((PsiElement)element));
        }).forEach(infos::add));
        ArrayList<RailsRouteUrlTargetInfo> arrayList = infos;
        if (arrayList == null) {
            RailsRouteUrlTargetInfo.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementPointer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/microservices/url/RailsRouteUrlTargetInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/microservices/url/RailsRouteUrlTargetInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorities";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromRoutes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFromRoutes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

