/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.microservices.endpoints;

import com.intellij.lang.Language;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.microservices.url.RailsRouteUrlTargetInfo;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

final class RailsEndpointsProvider
implements EndpointsUrlTargetProvider<RoutesParser, RailsRouteUrlTargetInfo> {
    RailsEndpointsProvider() {
    }

    @NotNull
    public Iterable<RailsRouteUrlTargetInfo> getEndpoints(@NotNull RoutesParser group) {
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(0);
        }
        Collection<RailsRouteUrlTargetInfo> collection = RailsRouteUrlTargetInfo.createFromRoutes(group.getRoutes());
        if (collection == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull RoutesParser group, @NotNull RailsRouteUrlTargetInfo endpoint) {
        RPsiElement statement;
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(2);
        }
        if (endpoint == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(3);
        }
        return (statement = RubyPsiUtilCore.getStatement((PsiElement)endpoint.resolveToPsiElement())) instanceof RBlockCall ? ((RBlockCall)statement).getPsiCommand() : statement;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull RoutesParser group, @NotNull RailsRouteUrlTargetInfo endpoint) {
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(4);
        }
        if (endpoint == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(5);
        }
        return endpoint.resolveToPsiElement();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull RoutesParser group, @NotNull RailsRouteUrlTargetInfo endpoint) {
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(6);
        }
        if (endpoint == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(7);
        }
        List<UrlTargetInfo> list = List.of(endpoint);
        if (list == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Iterable<RoutesParser> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(10);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List<RoutesParser> list = Collections.emptyList();
            if (list == null) {
                RailsEndpointsProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<RoutesParser> list = List.of(RoutesParser.getInstance((Module)((ModuleEndpointsFilter)filter).getModule()));
        if (list == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull RoutesParser group, @NotNull RailsRouteUrlTargetInfo endpoint) {
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(13);
        }
        if (endpoint == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(14);
        }
        String path = endpoint.getPath().getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
        return new HttpMethodPresentation("/" + StringUtil.trimStart((String)path, (String)"/"), List.copyOf(endpoint.getMethods()), endpoint.getSource(), endpoint.getIcon());
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
        if (endpointType == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(15);
        }
        return endpointType;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(16);
        }
        ModificationTracker modificationTracker = PsiManager.getInstance((Project)project).getModificationTracker().forLanguage((Language)RubyLanguage.INSTANCE);
        if (modificationTracker == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(17);
        }
        return modificationTracker;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return new FrameworkPresentation("Rails-HTTP-Server", RBundle.message((String)"rails.microservices.http.server.endpoint.title"), RubyIcons.Rails.Rails);
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(18);
        }
        if (!ContainerUtil.exists((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project), RailsFacetUtil::hasRailsSupport)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                RailsEndpointsProvider.$$$reportNull$$$0(19);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
        if (status == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(20);
        }
        return status;
    }

    public boolean isValidEndpoint(@NotNull RoutesParser group, @NotNull RailsRouteUrlTargetInfo endpoint) {
        PsiElement element;
        if (group == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(21);
        }
        if (endpoint == null) {
            RailsEndpointsProvider.$$$reportNull$$$0(22);
        }
        return (element = endpoint.resolveToPsiElement()) != null && element.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 11, 12, 15, 17, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/microservices/endpoints/RailsEndpointsProvider";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/microservices/endpoints/RailsEndpointsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTargetInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrlTargetInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 11, 12, 15, 17, 19, 20 -> new IllegalStateException(string);
        };
    }
}

