extends RefCounted
class_name ZIPPacker

## Allows the creation of ZIP files.
##
## This class implements a writer that allows storing the multiple blobs in a ZIP archive. See also [ZIPReader] and [PCKPacker].
## [codeblock]
## # Create a ZIP archive with a single file at its root.
## func write_zip_file():
## var writer = ZIPPacker.new()
## var err = writer.open("user://archive.zip")
## if err != OK:
## return err
## writer.start_file("hello.txt")
## writer.write_file("Hello World".to_utf8_buffer())
## writer.close_file()
## writer.close()
## return OK
## [/codeblock]


## Create a new zip archive at the given path.
## Append a new zip archive to the end of the already existing file at the given path.
## Add new files to the existing zip archive at the given path.
## Start a file with the default Deflate compression level ([code]6[/code]). This is a good compromise between speed and file size.
## Start a file with no compression. This is also known as the "Store" compression mode and is the fastest method of packing files inside a ZIP archive. Consider using this mode for files that are already compressed (such as JPEG, PNG, MP3, or Ogg Vorbis files).
## Start a file with the fastest Deflate compression level ([code]1[/code]). This is fast to compress, but results in larger file sizes than [constant COMPRESSION_DEFAULT]. Decompression speed is generally unaffected by the chosen compression level.
## Start a file with the the best Deflate compression level ([code]9[/code]). This is slow to compress, but results in smaller file sizes than [constant COMPRESSION_DEFAULT]. Decompression speed is generally unaffected by the chosen compression level.

#enum ZipAppend
enum {
    APPEND_CREATE = 0,
    APPEND_CREATEAFTER = 1,
    APPEND_ADDINZIP = 2,
}
#enum CompressionLevel
enum {
    COMPRESSION_DEFAULT = -1,
    COMPRESSION_NONE = 0,
    COMPRESSION_FAST = 1,
    COMPRESSION_BEST = 9,
}
## The compression level used when [method start_file] is called. Use [enum ZIPPacker.CompressionLevel] as a reference.
var compression_level: int:
	get = get_compression_level, set = set_compression_level



## Closes the underlying resources used by this instance.
func close() -> int:
	pass;

## Stops writing to a file within the archive.
## It will fail if there is no open file.
func close_file() -> int:
	pass;

## Opens a zip file for writing at the given path using the specified write mode.
## This must be called before everything else.
func open(path: String, append: int = 0) -> int:
	pass;

## Starts writing to a file within the archive. Only one file can be written at the same time.
## Must be called after [method open].
func start_file(path: String) -> int:
	pass;

## Write the given [param data] to the file.
## Needs to be called after [method start_file].
func write_file(data: PackedByteArray) -> int:
	pass;


func get_compression_level() -> int:
	return compression_level

func set_compression_level(value: int) -> void:
	compression_level = value

