extends RefCounted
class_name XRTracker

## A tracked object.
##
## This object is the base of all XR trackers.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html



## The description of this tracker.
var description: String:
	get = get_tracker_desc, set = set_tracker_desc

## The unique name of this tracker. The trackers that are available differ between various XR runtimes and can often be configured by the user. Godot maintains a number of reserved names that it expects the [XRInterface] to implement if applicable:
## - [code]head[/code] identifies the [XRPositionalTracker] of the players head
## - [code]left_hand[/code] identifies the [XRControllerTracker] in the players left hand
## - [code]right_hand[/code] identifies the [XRControllerTracker] in the players right hand
## - [code]/user/hand_tracker/left[/code] identifies the [XRHandTracker] for the players left hand
## - [code]/user/hand_tracker/right[/code] identifies the [XRHandTracker] for the players right hand
## - [code]/user/body_tracker[/code] identifies the [XRBodyTracker] for the players body
## - [code]/user/face_tracker[/code] identifies the [XRFaceTracker] for the players face
var name: StringName:
	get = get_tracker_name, set = set_tracker_name

## The type of tracker.
var type: int:
	get = get_tracker_type, set = set_tracker_type




func get_tracker_desc() -> String:
	return description

func set_tracker_desc(value: String) -> void:
	description = value

func get_tracker_name() -> StringName:
	return name

func set_tracker_name(value: StringName) -> void:
	name = value

func get_tracker_type() -> int:
	return type

func set_tracker_type(value: int) -> void:
	type = value

