extends XRPositionalTracker
class_name XRHandTracker

## A tracked hand in XR.
##
## A hand tracking system will create an instance of this object and add it to the [XRServer]. This tracking system will then obtain skeleton data, convert it to the Godot Humanoid hand skeleton and store this data on the [XRHandTracker] object.
## Use [XRHandModifier3D] to animate a hand mesh using hand tracking data.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## The source of hand tracking data is unknown.
## The source of hand tracking data is unobstructed, meaning that an accurate method of hand tracking is used. These include optical hand tracking, data gloves, etc.
## The source of hand tracking data is a controller, meaning that joint positions are inferred from controller inputs.
## No hand tracking data is tracked, this either means the hand is obscured, the controller is turned off, or tracking is not supported for the current input type.
## Represents the size of the [enum HandTrackingSource] enum.
## Palm joint.
## Wrist joint.
## Thumb metacarpal joint.
## Thumb phalanx proximal joint.
## Thumb phalanx distal joint.
## Thumb tip joint.
## Index finger metacarpal joint.
## Index finger phalanx proximal joint.
## Index finger phalanx intermediate joint.
## Index finger phalanx distal joint.
## Index finger tip joint.
## Middle finger metacarpal joint.
## Middle finger phalanx proximal joint.
## Middle finger phalanx intermediate joint.
## Middle finger phalanx distal joint.
## Middle finger tip joint.
## Ring finger metacarpal joint.
## Ring finger phalanx proximal joint.
## Ring finger phalanx intermediate joint.
## Ring finger phalanx distal joint.
## Ring finger tip joint.
## Pinky finger metacarpal joint.
## Pinky finger phalanx proximal joint.
## Pinky finger phalanx intermediate joint.
## Pinky finger phalanx distal joint.
## Pinky finger tip joint.
## Represents the size of the [enum HandJoint] enum.
## The hand joint's orientation data is valid.
## The hand joint's orientation is actively tracked. May not be set if tracking has been temporarily lost.
## The hand joint's position data is valid.
## The hand joint's position is actively tracked. May not be set if tracking has been temporarily lost.
## The hand joint's linear velocity data is valid.
## The hand joint's angular velocity data is valid.

#enum HandTrackingSource
enum {
    HAND_TRACKING_SOURCE_UNKNOWN = 0,
    HAND_TRACKING_SOURCE_UNOBSTRUCTED = 1,
    HAND_TRACKING_SOURCE_CONTROLLER = 2,
    HAND_TRACKING_SOURCE_NOT_TRACKED = 3,
    HAND_TRACKING_SOURCE_MAX = 4,
}
#enum HandJoint
enum {
    HAND_JOINT_PALM = 0,
    HAND_JOINT_WRIST = 1,
    HAND_JOINT_THUMB_METACARPAL = 2,
    HAND_JOINT_THUMB_PHALANX_PROXIMAL = 3,
    HAND_JOINT_THUMB_PHALANX_DISTAL = 4,
    HAND_JOINT_THUMB_TIP = 5,
    HAND_JOINT_INDEX_FINGER_METACARPAL = 6,
    HAND_JOINT_INDEX_FINGER_PHALANX_PROXIMAL = 7,
    HAND_JOINT_INDEX_FINGER_PHALANX_INTERMEDIATE = 8,
    HAND_JOINT_INDEX_FINGER_PHALANX_DISTAL = 9,
    HAND_JOINT_INDEX_FINGER_TIP = 10,
    HAND_JOINT_MIDDLE_FINGER_METACARPAL = 11,
    HAND_JOINT_MIDDLE_FINGER_PHALANX_PROXIMAL = 12,
    HAND_JOINT_MIDDLE_FINGER_PHALANX_INTERMEDIATE = 13,
    HAND_JOINT_MIDDLE_FINGER_PHALANX_DISTAL = 14,
    HAND_JOINT_MIDDLE_FINGER_TIP = 15,
    HAND_JOINT_RING_FINGER_METACARPAL = 16,
    HAND_JOINT_RING_FINGER_PHALANX_PROXIMAL = 17,
    HAND_JOINT_RING_FINGER_PHALANX_INTERMEDIATE = 18,
    HAND_JOINT_RING_FINGER_PHALANX_DISTAL = 19,
    HAND_JOINT_RING_FINGER_TIP = 20,
    HAND_JOINT_PINKY_FINGER_METACARPAL = 21,
    HAND_JOINT_PINKY_FINGER_PHALANX_PROXIMAL = 22,
    HAND_JOINT_PINKY_FINGER_PHALANX_INTERMEDIATE = 23,
    HAND_JOINT_PINKY_FINGER_PHALANX_DISTAL = 24,
    HAND_JOINT_PINKY_FINGER_TIP = 25,
    HAND_JOINT_MAX = 26,
}
#enum HandJointFlags
enum {
    HAND_JOINT_FLAG_ORIENTATION_VALID = 1,
    HAND_JOINT_FLAG_ORIENTATION_TRACKED = 2,
    HAND_JOINT_FLAG_POSITION_VALID = 4,
    HAND_JOINT_FLAG_POSITION_TRACKED = 8,
    HAND_JOINT_FLAG_LINEAR_VELOCITY_VALID = 16,
    HAND_JOINT_FLAG_ANGULAR_VELOCITY_VALID = 32,
}
var hand: int:
	get = get_tracker_hand, set = set_tracker_hand

## The source of the hand tracking data.
var hand_tracking_source: int:
	get = get_hand_tracking_source, set = set_hand_tracking_source

## If [code]true[/code], the hand tracking data is valid.
var has_tracking_data: bool:
	get = get_has_tracking_data, set = set_has_tracking_data

var type: int:
	get = get_tracker_type, set = set_tracker_type



## Returns the angular velocity for the given hand joint.
func get_hand_joint_angular_velocity(joint: int) -> Vector3:
	pass;

## Returns flags about the validity of the tracking data for the given hand joint.
func get_hand_joint_flags(joint: int) -> int:
	pass;

## Returns the linear velocity for the given hand joint.
func get_hand_joint_linear_velocity(joint: int) -> Vector3:
	pass;

## Returns the radius of the given hand joint.
func get_hand_joint_radius(joint: int) -> float:
	pass;

## Returns the transform for the given hand joint.
func get_hand_joint_transform(joint: int) -> Transform3D:
	pass;

## Sets the angular velocity for the given hand joint.
func set_hand_joint_angular_velocity(joint: int, angular_velocity: Vector3) -> void:
	pass;

## Sets flags about the validity of the tracking data for the given hand joint.
func set_hand_joint_flags(joint: int, flags: int) -> void:
	pass;

## Sets the linear velocity for the given hand joint.
func set_hand_joint_linear_velocity(joint: int, linear_velocity: Vector3) -> void:
	pass;

## Sets the radius of the given hand joint.
func set_hand_joint_radius(joint: int, radius: float) -> void:
	pass;

## Sets the transform for the given hand joint.
func set_hand_joint_transform(joint: int, transform: Transform3D) -> void:
	pass;


func get_tracker_hand() -> int:
	return hand

func set_tracker_hand(value: int) -> void:
	hand = value

func get_hand_tracking_source() -> int:
	return hand_tracking_source

func set_hand_tracking_source(value: int) -> void:
	hand_tracking_source = value

func get_has_tracking_data() -> bool:
	return has_tracking_data

func set_has_tracking_data(value: bool) -> void:
	has_tracking_data = value

func get_tracker_type() -> int:
	return type

func set_tracker_type(value: int) -> void:
	type = value

