extends SkeletonModifier3D
class_name XRHandModifier3D

## A node for driving hand meshes from [XRHandTracker] data.
##
## This node uses hand tracking data from an [XRHandTracker] to pose the skeleton of a hand mesh.
## Positioning of hands is performed by creating an [XRNode3D] ancestor of the hand mesh driven by the same [XRHandTracker].
## The hand tracking position-data is scaled by [member Skeleton3D.motion_scale] when applied to the skeleton, which can be used to adjust the tracked hand to match the scale of the hand model.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## The skeleton's bones are fully updated (both position and rotation) to match the tracked bones.
## The skeleton's bones are only rotated to align with the tracked bones, preserving bone length.
## Represents the size of the [enum BoneUpdate] enum.

#enum BoneUpdate
enum {
    BONE_UPDATE_FULL = 0,
    BONE_UPDATE_ROTATION_ONLY = 1,
    BONE_UPDATE_MAX = 2,
}
## Specifies the type of updates to perform on the bones.
var bone_update: int:
	get = get_bone_update, set = set_bone_update

## The name of the [XRHandTracker] registered with [XRServer] to obtain the hand tracking data from.
var hand_tracker: StringName:
	get = get_hand_tracker, set = set_hand_tracker




func get_bone_update() -> int:
	return bone_update

func set_bone_update(value: int) -> void:
	bone_update = value

func get_hand_tracker() -> StringName:
	return hand_tracker

func set_hand_tracker(value: StringName) -> void:
	hand_tracker = value

