extends SkeletonModifier3D
class_name XRBodyModifier3D

## A node for driving body meshes from [XRBodyTracker] data.
##
## This node uses body tracking data from an [XRBodyTracker] to pose the skeleton of a body mesh.
## Positioning of the body is performed by creating an [XRNode3D] ancestor of the body mesh driven by the same [XRBodyTracker].
## The body tracking position-data is scaled by [member Skeleton3D.motion_scale] when applied to the skeleton, which can be used to adjust the tracked body to match the scale of the body model.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## The skeleton's upper body joints are updated.
## The skeleton's lower body joints are updated.
## The skeleton's hand joints are updated.
## The skeleton's bones are fully updated (both position and rotation) to match the tracked bones.
## The skeleton's bones are only rotated to align with the tracked bones, preserving bone length.
## Represents the size of the [enum BoneUpdate] enum.

#enum BodyUpdate
enum {
    BODY_UPDATE_UPPER_BODY = 1,
    BODY_UPDATE_LOWER_BODY = 2,
    BODY_UPDATE_HANDS = 4,
}
#enum BoneUpdate
enum {
    BONE_UPDATE_FULL = 0,
    BONE_UPDATE_ROTATION_ONLY = 1,
    BONE_UPDATE_MAX = 2,
}
## The name of the [XRBodyTracker] registered with [XRServer] to obtain the body tracking data from.
var body_tracker: StringName:
	get = get_body_tracker, set = set_body_tracker

## Specifies the body parts to update.
var body_update: int:
	get = get_body_update, set = set_body_update

## Specifies the type of updates to perform on the bones.
var bone_update: int:
	get = get_bone_update, set = set_bone_update




func get_body_tracker() -> StringName:
	return body_tracker

func set_body_tracker(value: StringName) -> void:
	body_tracker = value

func get_body_update() -> int:
	return body_update

func set_body_update(value: int) -> void:
	body_update = value

func get_bone_update() -> int:
	return bone_update

func set_bone_update(value: int) -> void:
	bone_update = value

