extends VisualShaderNode
class_name VisualShaderNodeTransformFunc

## Computes a [Transform3D] function within the visual shader graph.
##
## Computes an inverse or transpose function on the provided [Transform3D].


## Perform the inverse operation on the [Transform3D] matrix.
## Perform the transpose operation on the [Transform3D] matrix.
## Represents the size of the [enum Function] enum.

#enum Function
enum {
    FUNC_INVERSE = 0,
    FUNC_TRANSPOSE = 1,
    FUNC_MAX = 2,
}
## The function to be computed.
var function: int:
	get = get_function, set = set_function




func get_function() -> int:
	return function

func set_function(value: int) -> void:
	function = value

