extends VisualShaderNode
class_name VisualShaderNodeSample3D

## A base node for nodes which samples 3D textures in the visual shader graph.
##
## A virtual class, use the descendants instead.


## Creates internal uniform and provides a way to assign it within node.
## Use the uniform texture from sampler port.
## Represents the size of the [enum Source] enum.

#enum Source
enum {
    SOURCE_TEXTURE = 0,
    SOURCE_PORT = 1,
    SOURCE_MAX = 2,
}
## An input source type.
var source: int:
	get = get_source, set = set_source




func get_source() -> int:
	return source

func set_source(value: int) -> void:
	source = value

