extends VisualShaderNode
class_name VisualShaderNodeIs

## A boolean comparison operator to be used within the visual shader graph.
##
## Returns the boolean result of the comparison between [code]INF[/code] or [code]NaN[/code] and a scalar parameter.


## Comparison with [code]INF[/code] (Infinity).
## Comparison with [code]NaN[/code] (Not a Number; indicates invalid numeric results, such as division by zero).
## Represents the size of the [enum Function] enum.

#enum Function
enum {
    FUNC_IS_INF = 0,
    FUNC_IS_NAN = 1,
    FUNC_MAX = 2,
}
## The comparison function.
var function: int:
	get = get_function, set = set_function




func get_function() -> int:
	return function

func set_function(value: int) -> void:
	function = value

