extends VisualShaderNode
class_name VisualShaderNodeIntOp

## An integer scalar operator to be used within the visual shader graph.
##
## Applies [member operator] to two integer inputs: [code]a[/code] and [code]b[/code].


## Sums two numbers using [code]a + b[/code].
## Subtracts two numbers using [code]a - b[/code].
## Multiplies two numbers using [code]a * b[/code].
## Divides two numbers using [code]a / b[/code].
## Calculates the remainder of two numbers using [code]a % b[/code].
## Returns the greater of two numbers. Translates to [code]max(a, b)[/code] in the Godot Shader Language.
## Returns the lesser of two numbers. Translates to [code]max(a, b)[/code] in the Godot Shader Language.
## Returns the result of bitwise [code]AND[/code] operation on the integer. Translates to [code]a & b[/code] in the Godot Shader Language.
## Returns the result of bitwise [code]OR[/code] operation for two integers. Translates to [code]a | b[/code] in the Godot Shader Language.
## Returns the result of bitwise [code]XOR[/code] operation for two integers. Translates to [code]a ^ b[/code] in the Godot Shader Language.
## Returns the result of bitwise left shift operation on the integer. Translates to [code]a << b[/code] in the Godot Shader Language.
## Returns the result of bitwise right shift operation on the integer. Translates to [code]a >> b[/code] in the Godot Shader Language.
## Represents the size of the [enum Operator] enum.

#enum Operator
enum {
    OP_ADD = 0,
    OP_SUB = 1,
    OP_MUL = 2,
    OP_DIV = 3,
    OP_MOD = 4,
    OP_MAX = 5,
    OP_MIN = 6,
    OP_BITWISE_AND = 7,
    OP_BITWISE_OR = 8,
    OP_BITWISE_XOR = 9,
    OP_BITWISE_LEFT_SHIFT = 10,
    OP_BITWISE_RIGHT_SHIFT = 11,
    OP_ENUM_SIZE = 12,
}
## An operator to be applied to the inputs.
var operator: int:
	get = get_operator, set = set_operator




func get_operator() -> int:
	return operator

func set_operator(value: int) -> void:
	operator = value

