extends VisualShaderNode
class_name VisualShaderNodeColorOp

## A [Color] operator to be used within the visual shader graph.
##
## Applies [member operator] to two color inputs.


## Produce a screen effect with the following formula:
## [codeblock]
## result = vec3(1.0) - (vec3(1.0) - a) * (vec3(1.0) - b);
## [/codeblock]
## Produce a difference effect with the following formula:
## [codeblock]
## result = abs(a - b);
## [/codeblock]
## Produce a darken effect with the following formula:
## [codeblock]
## result = min(a, b);
## [/codeblock]
## Produce a lighten effect with the following formula:
## [codeblock]
## result = max(a, b);
## [/codeblock]
## Produce an overlay effect with the following formula:
## [codeblock]
## for (int i = 0; i < 3; i++) {
## float base = a[i];
## float blend = b[i];
## if (base < 0.5) {
## result[i] = 2.0 * base * blend;
## } else {
## result[i] = 1.0 - 2.0 * (1.0 - blend) * (1.0 - base);
## }
## }
## [/codeblock]
## Produce a dodge effect with the following formula:
## [codeblock]
## result = a / (vec3(1.0) - b);
## [/codeblock]
## Produce a burn effect with the following formula:
## [codeblock]
## result = vec3(1.0) - (vec3(1.0) - a) / b;
## [/codeblock]
## Produce a soft light effect with the following formula:
## [codeblock]
## for (int i = 0; i < 3; i++) {
## float base = a[i];
## float blend = b[i];
## if (base < 0.5) {
## result[i] = base * (blend + 0.5);
## } else {
## result[i] = 1.0 - (1.0 - base) * (1.0 - (blend - 0.5));
## }
## }
## [/codeblock]
## Produce a hard light effect with the following formula:
## [codeblock]
## for (int i = 0; i < 3; i++) {
## float base = a[i];
## float blend = b[i];
## if (base < 0.5) {
## result[i] = base * (2.0 * blend);
## } else {
## result[i] = 1.0 - (1.0 - base) * (1.0 - 2.0 * (blend - 0.5));
## }
## }
## [/codeblock]
## Represents the size of the [enum Operator] enum.

#enum Operator
enum {
    OP_SCREEN = 0,
    OP_DIFFERENCE = 1,
    OP_DARKEN = 2,
    OP_LIGHTEN = 3,
    OP_OVERLAY = 4,
    OP_DODGE = 5,
    OP_BURN = 6,
    OP_SOFT_LIGHT = 7,
    OP_HARD_LIGHT = 8,
    OP_MAX = 9,
}
## An operator to be applied to the inputs.
var operator: int:
	get = get_operator, set = set_operator




func get_operator() -> int:
	return operator

func set_operator(value: int) -> void:
	operator = value

