extends PrimitiveMesh
class_name TubeTrailMesh

## Represents a straight tube-shaped [PrimitiveMesh] with variable width.
##
## [TubeTrailMesh] represents a straight tube-shaped mesh with variable width. The tube is composed of a number of cylindrical sections, each with the same [member section_length] and number of [member section_rings]. A [member curve] is sampled along the total length of the tube, meaning that the curve determines the radius of the tube along its length.
## This primitive mesh is usually used for particle trails.
##
## @tutorial(3D Particle trails): https://docs.godotengine.org/en/stable/tutorials/3d/particles/trails.html
## @tutorial(Particle systems (3D)): https://docs.godotengine.org/en/stable/tutorials/3d/particles/index.html



## If [code]true[/code], generates a cap at the bottom of the tube. This can be set to [code]false[/code] to speed up generation and rendering when the cap is never seen by the camera.
var cap_bottom: bool:
	get = is_cap_bottom, set = set_cap_bottom

## If [code]true[/code], generates a cap at the top of the tube. This can be set to [code]false[/code] to speed up generation and rendering when the cap is never seen by the camera.
var cap_top: bool:
	get = is_cap_top, set = set_cap_top

## Determines the radius of the tube along its length. The radius of a particular section ring is obtained by multiplying the baseline [member radius] by the value of this curve at the given distance. For values smaller than [code]0[/code], the faces will be inverted. Should be a unit [Curve].
var curve: Curve:
	get = get_curve, set = set_curve

## The number of sides on the tube. For example, a value of [code]5[/code] means the tube will be pentagonal. Higher values result in a more detailed tube at the cost of performance.
var radial_steps: int:
	get = get_radial_steps, set = set_radial_steps

## The baseline radius of the tube. The radius of a particular section ring is obtained by multiplying this radius by the value of the [member curve] at the given distance.
var radius: float:
	get = get_radius, set = set_radius

## The length of a section of the tube.
var section_length: float:
	get = get_section_length, set = set_section_length

## The number of rings in a section. The [member curve] is sampled on each ring to determine its radius. Higher values result in a more detailed tube at the cost of performance.
var section_rings: int:
	get = get_section_rings, set = set_section_rings

## The total number of sections on the tube.
var sections: int:
	get = get_sections, set = set_sections




func is_cap_bottom() -> bool:
	return cap_bottom

func set_cap_bottom(value: bool) -> void:
	cap_bottom = value

func is_cap_top() -> bool:
	return cap_top

func set_cap_top(value: bool) -> void:
	cap_top = value

func get_curve() -> Curve:
	return curve

func set_curve(value: Curve) -> void:
	curve = value

func get_radial_steps() -> int:
	return radial_steps

func set_radial_steps(value: int) -> void:
	radial_steps = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_section_length() -> float:
	return section_length

func set_section_length(value: float) -> void:
	section_length = value

func get_section_rings() -> int:
	return section_rings

func set_section_rings(value: int) -> void:
	section_rings = value

func get_sections() -> int:
	return sections

func set_sections(value: int) -> void:
	sections = value

