extends RefCounted
class_name TriangleMesh

## Triangle geometry for efficient, physicsless intersection queries.
##
## Creates a bounding volume hierarchy (BVH) tree structure around triangle geometry.
## The triangle BVH tree can be used for efficient intersection queries without involving a physics engine.
## For example, this can be used in editor tools to select objects with complex shapes based on the mouse cursor position.
## [b]Performance:[/b] Creating the BVH tree for complex geometry is a slow process and best done in a background thread.





## Creates the BVH tree from an array of faces. Each 3 vertices of the input [param faces] array represent one triangle (face).
## Returns [code]true[/code] if the tree is successfully built, [code]false[/code] otherwise.
func create_from_faces(faces: PackedVector3Array) -> bool:
	pass;

## Returns a copy of the geometry faces. Each 3 vertices of the array represent one triangle (face).
func get_faces() -> PackedVector3Array:
	pass;

## Tests for intersection with a ray starting at [param begin] and facing [param dir] and extending toward infinity.
## If an intersection with a triangle happens, returns a [Dictionary] with the following fields:
## [code]position[/code]: The position on the intersected triangle.
## [code]normal[/code]: The normal of the intersected triangle.
## [code]face_index[/code]: The index of the intersected triangle.
## Returns an empty [Dictionary] if no intersection happens.
## See also [method intersect_segment], which is similar but uses a finite-length segment.
func intersect_ray(begin: Vector3, dir: Vector3) -> Dictionary:
	pass;

## Tests for intersection with a segment going from [param begin] to [param end].
## If an intersection with a triangle happens returns a [Dictionary] with the following fields:
## [code]position[/code]: The position on the intersected triangle.
## [code]normal[/code]: The normal of the intersected triangle.
## [code]face_index[/code]: The index of the intersected triangle.
## Returns an empty [Dictionary] if no intersection happens.
## See also [method intersect_ray], which is similar but uses an infinite-length ray.
func intersect_segment(begin: Vector3, end: Vector3) -> Dictionary:
	pass;


