extends Resource
class_name SyntaxHighlighter

## Base class for syntax highlighters. Provides syntax highlighting data to a [TextEdit].
##
## Base class for syntax highlighters. Provides syntax highlighting data to a [TextEdit]. The associated [TextEdit] will call into the [SyntaxHighlighter] on an as-needed basis.
## [b]Note:[/b] A [SyntaxHighlighter] instance should not be used across multiple [TextEdit] nodes.





## Virtual method which can be overridden to clear any local caches.
func _clear_highlighting_cache() -> void:
	pass;

## Virtual method which can be overridden to return syntax highlighting data.
## See [method get_line_syntax_highlighting] for more details.
func _get_line_syntax_highlighting(line: int) -> Dictionary:
	pass;

## Virtual method which can be overridden to update any local caches.
func _update_cache() -> void:
	pass;

## Clears all cached syntax highlighting data.
## Then calls overridable method [method _clear_highlighting_cache].
func clear_highlighting_cache() -> void:
	pass;

## Returns the syntax highlighting data for the line at index [param line]. If the line is not cached, calls [method _get_line_syntax_highlighting] first to calculate the data.
## Each entry is a column number containing a nested [Dictionary]. The column number denotes the start of a region, the region will end if another region is found, or at the end of the line. The nested [Dictionary] contains the data for that region. Currently only the key [code]"color"[/code] is supported.
## [b]Example:[/b] Possible return value. This means columns [code]0[/code] to [code]4[/code] should be red, and columns [code]5[/code] to the end of the line should be green:
## [codeblock]
## {
## 0: {
## "color": Color(1, 0, 0)
## },
## 5: {
## "color": Color(0, 1, 0)
## }
## }
## [/codeblock]
func get_line_syntax_highlighting(line: int) -> Dictionary:
	pass;

## Returns the associated [TextEdit] node.
func get_text_edit() -> TextEdit:
	pass;

## Clears then updates the [SyntaxHighlighter] caches. Override [method _update_cache] for a callback.
## [b]Note:[/b] This is called automatically when the associated [TextEdit] node, updates its own cache.
func update_cache() -> void:
	pass;


